/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.authn.AuthenticationClient;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.security.FederatedIdentityAccessTokenRequest;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.json.JSONObject;
import java.security.AccessController;
import java.util.HashMap;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"cloudLink:CloudAuthenticationScheme"})})
public class BFoxCloudAuthnHandler
extends BFoxClientAuthnHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxCloudAuthnHandler.class);
    private BCertificateAliasCredential certAliasCredential = new BCertificateAliasCredential();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handleAuthentication(FoxSession session, AuthenticationClient authenticationClient) throws Exception {
        String scheme;
        BFoxClientConnection foxClientConnection = (BFoxClientConnection)session.conn();
        if (!foxClientConnection.getFoxOverWebsocket().equals((Object)BFoxClientWebsocketBehavior.useWebsocketOnly)) {
            throw new FoxAuthenticationException("Fox over websocket required", session);
        }
        BFoxSession realm = foxClientConnection.getFoxSession();
        BICredentials credentials = authenticationClient.requestInformation((AuthenticationRealm)realm, scheme = foxClientConnection.getAuthenticationScheme(), 0, (BIObject)this.certAliasCredential);
        if (credentials == null) {
            throw new FoxAuthenticationException("Cancelled", scheme, null, session);
        }
        if (!(credentials instanceof BCertificateAliasCredential)) {
            throw new FoxAuthenticationException("Unsupported credentials: " + credentials.getType(), scheme, null, session);
        }
        this.certAliasCredential = (BCertificateAliasCredential)credentials;
        FoxMessage login = new FoxMessage();
        login.add("token", this.getToken(foxClientConnection, session));
        session.setState("client.tune CloudAuthnHandler send login");
        session.sendTuning("login", login);
        authenticationClient.setPreconnectCredentials(null);
    }

    public void setData(BIObject data) {
        if (data instanceof BUsernameCredential) {
            this.certAliasCredential.setUsername(((BUsernameCredential)data).getUsername());
        } else if (data instanceof BCertificateAliasCredential) {
            this.certAliasCredential = (BCertificateAliasCredential)data;
        } else {
            throw new UnsupportedOperationException("Data type not supported.");
        }
    }

    private String getToken(BFoxClientConnection connection, FoxSession session) throws FoxAuthenticationException {
        BComplex parent = connection.getParent();
        if (parent == null) {
            throw new FoxAuthenticationException("Unparented BFoxClientConnection", session);
        }
        BHost host = (BHost)((BOrd)parent.get("address")).get();
        String deviceId = ((BString)parent.get("deviceId")).getString();
        BCloudConnectionService ccs = (BCloudConnectionService)Sys.getService((Type)BCloudConnectionService.TYPE);
        BFederatedIdentityAuthenticator authenticator = (BFederatedIdentityAuthenticator)ccs.getAuthenticator("FederatedIdentity");
        HashMap props = new HashMap();
        AccessController.doPrivileged(() -> {
            authenticator.addMessageHandlerProperties(null, null, props);
            return null;
        });
        BCertificateAliasAndPassword certAliasAndPass = (BCertificateAliasAndPassword)props.get("certAliasAndPassword");
        FederatedIdentityAccessTokenRequest request = new FederatedIdentityAccessTokenRequest(host.getHostname(), deviceId, certAliasAndPass);
        BMessagingChannel messagingChannel = (BMessagingChannel)ccs.getChannel("Messaging");
        HttpResponseMessage response = (HttpResponseMessage)AccessController.doPrivileged(() -> messagingChannel.send("HTTP", request.toMessage(true)));
        if (response.getStatusCode() != 200) {
            throw new FoxAuthenticationException("Error requesting device token", session);
        }
        JSONObject jsonResponse = new JSONObject(response.getBodyAsString());
        return jsonResponse.getString("accessToken");
    }
}

