/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.security.BRoleMapping;
import com.tridium.util.EscUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BAdminRole;
import javax.baja.role.BIRole;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissionsMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="reassertMissingStandardRoles", type="boolean", defaultValue="true")
public class BCloudRoleMappings
extends BComponent {
    @Generated
    public static final Property reassertMissingStandardRoles = BCloudRoleMappings.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudRoleMappings.class);
    private final Map<String, BRoleMapping> mappingsByCloudRole = new HashMap<String, BRoleMapping>();
    private final Map<Property, String> byProperty = new HashMap<Property, String>();
    public static final String CLOUD_USER_ROLE = "CloudUser";
    public static final String CLOUD_OPERATOR_ROLE = "CloudOperator";
    public static final String CLOUD_ADMIN_ROLE = "CloudAdmin";
    public static final String CLOUD_USER_PERMISSIONS = "1=rR";
    public static final String CLOUD_OPERATOR_PERMISSIONS = "1=rwiRWI";
    public static final String CLOUD_ADMIN_PERMISSIONS = "1=rwiRWI;2=rwiRWI";
    public static final String CLOUD_USER_PERMISSIONS_OLD_DEFAULT = "1=r;2=r";
    public static final String CLOUD_OPERATOR_PERMISSIONS_OLD_DEFAULT = "1=rwi;2=r";
    private static final String ROLE_MAPPING_DISABLED = "Role Mapping disabled; permissions of standard role have been modified";
    private static final String NULL_MAPPING = "NULL";
    protected static final Logger log = Logger.getLogger("cloudLink.security");

    @Generated
    public boolean getReassertMissingStandardRoles() {
        return this.getBoolean(reassertMissingStandardRoles);
    }

    @Generated
    public void setReassertMissingStandardRoles(boolean v) {
        this.setBoolean(reassertMissingStandardRoles, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIRole mapCloudRole(String cloudRole) {
        if (cloudRole == null) {
            return null;
        }
        BRoleMapping mapping = this.mappingsByCloudRole.get(cloudRole);
        if (mapping == null) {
            return null;
        }
        BIRole role = BRoleService.getService().getRole(EscUtil.slot.escape(mapping.getStationRole()));
        return role instanceof BAdminRole ? null : role;
    }

    public String mapCloudRoles(String cloudRoles) {
        Set stationRolesSet = Stream.of(cloudRoles.split(",")).filter(p -> this.mapCloudRole((String)p) != null).map(p -> this.mapCloudRole((String)p).getRoleIdentifier()).collect(Collectors.toSet());
        String stationRoles = String.join((CharSequence)",", stationRolesSet);
        log.config(() -> "Cloud Roles: " + cloudRoles);
        log.config(() -> "Station Roles: " + stationRoles);
        return stationRoles;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            BValue value = sc.get();
            if (!(value instanceof BRoleMapping)) continue;
            this.map(sc.property(), (BRoleMapping)value);
        }
    }

    public void atSteadyState() {
        if (this.getReassertMissingStandardRoles()) {
            this.checkStandardRole(CLOUD_USER_ROLE, CLOUD_USER_PERMISSIONS, CLOUD_USER_PERMISSIONS_OLD_DEFAULT);
            this.checkStandardRole(CLOUD_OPERATOR_ROLE, CLOUD_OPERATOR_PERMISSIONS, CLOUD_OPERATOR_PERMISSIONS_OLD_DEFAULT);
            this.checkStandardRole(CLOUD_ADMIN_ROLE, CLOUD_ADMIN_PERMISSIONS, null);
        }
    }

    public void changed(Property property, Context context) {
        BValue value;
        if (!this.isRunning() || context == CloudLinkUtils.fallbackContext) {
            return;
        }
        String oldCloudRole = this.byProperty.get(property);
        if (oldCloudRole != null) {
            this.unmap(property, oldCloudRole);
        }
        if ((value = this.get(property)) instanceof BRoleMapping) {
            this.map(property, (BRoleMapping)value);
        }
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BRoleMapping) {
            this.map(property, (BRoleMapping)value);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BRoleMapping) {
            this.unmap(property, ((BRoleMapping)value).getCloudRole());
        }
    }

    private void map(Property property, BRoleMapping mapping) {
        if (property != null && mapping != null && !mapping.getCloudRole().isEmpty()) {
            String cloudRole = mapping.getCloudRole();
            BRoleMapping existing = this.mappingsByCloudRole.get(cloudRole);
            if (existing == null) {
                this.byProperty.put(property, cloudRole);
                this.mappingsByCloudRole.put(cloudRole, mapping);
            } else {
                log.warning(() -> String.format("Duplicate role mapping of cloud role %s from %s to %s rejected", new Object[]{cloudRole, existing, mapping}));
                mapping.set(BRoleMapping.cloudRole, (BValue)BString.make((String)""), CloudLinkUtils.fallbackContext);
            }
        }
    }

    private void unmap(Property property, String cloudRole) {
        if (property != null && !cloudRole.isEmpty()) {
            this.byProperty.remove(property);
            this.mappingsByCloudRole.remove(cloudRole);
        }
    }

    private void checkStandardRole(String roleName, String rolePerms, String ignorePerms) {
        try {
            BRoleService roleService = (BRoleService)Sys.getService((Type)BRoleService.TYPE);
            BPermissionsMap permsMap = (BPermissionsMap)BPermissionsMap.DEFAULT.decodeFromString(rolePerms);
            BIRole role = roleService.getRole(roleName);
            if (role == null) {
                BRole r = new BRole();
                r.setPermissions(permsMap);
                roleService.add(roleName, (BValue)r);
            } else {
                BPermissionsMap rolePermsMap = role.getPermissions();
                if (!rolePermsMap.equals((Object)permsMap) && !rolePermsMap.encodeToString().equals(ignorePerms)) {
                    BRoleMapping[] mappings = (BRoleMapping[])this.getChildren(BRoleMapping.class);
                    boolean roleUsed = false;
                    for (BRoleMapping mapping : mappings) {
                        if (!mapping.getStationRole().equals(roleName)) continue;
                        roleUsed = true;
                        break;
                    }
                    if (roleUsed) {
                        log.warning(() -> String.format("Permissions for role %s (%s) have been changed from default value of %s. Please ensure that this is intentional by reviewing the station Role Service.", roleName, role.getPermissions(), rolePerms));
                    }
                }
            }
        }
        catch (Exception e) {
            log.warning(() -> String.format("Could not ensure role %s; role may not be available for cloud command mapping%s", roleName, log.isLoggable(Level.FINE) ? ": " + e.getMessage() : "."));
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"CloudRoleMappings", 2);
        out.startTable(true);
        out.trTitle((Object)"Cloud Roles Mapped By Property", 2);
        out.w((Object)"<tr>").th((Object)"Role Mapping Property").th((Object)"Cloud Role").w((Object)"</tr>\n");
        this.byProperty.forEach((arg_0, arg_1) -> ((SpyWriter)out).tr(arg_0, arg_1));
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Cloud Role Mappings", 2);
        out.w((Object)"<tr>").th((Object)"Cloud Role").th((Object)"Station Role").w((Object)"</tr>\n");
        this.mappingsByCloudRole.forEach((key, value) -> out.tr(key, (Object)BCloudRoleMappings.spyString(value.getStationRole())));
        out.endTable();
        out.endProps();
    }

    private static String spyString(String stationRole) {
        if (stationRole == null) {
            return NULL_MAPPING;
        }
        return stationRole.isEmpty() ? ROLE_MAPPING_DISABLED : stationRole;
    }
}

