/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.authn.BCallbackHandler;
import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.cloudLink.security.CloudCallback;
import java.io.IOException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"cloudLink:CloudAuthenticationScheme"})})
public class BCloudCallbackHandler
extends BCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudCallbackHandler.class);
    private CommandRequest commandRequest;
    private String deviceId;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void init(CommandRequest request, String deviceId) {
        this.commandRequest = request;
        this.deviceId = deviceId;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CloudCallback) {
                if (this.commandRequest != null) {
                    String appId = this.commandRequest.getCaller();
                    Object auth = this.commandRequest.getAuth();
                    if (auth != null && !(auth instanceof String)) {
                        throw new IOException("Wrong type for auth. Expected String but found " + auth.getClass());
                    }
                    ((CloudCallback)callback).setAppId(appId);
                    ((CloudCallback)callback).setJwt((String)auth);
                }
                ((CloudCallback)callback).setDeviceId(this.deviceId);
                if (this.commandRequest == null) continue;
                ((CloudCallback)callback).setMessageId(this.commandRequest.getMessageId());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }
}

