/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.cloudLink.security.BAbstractTrustMapping;
import com.tridium.cloudLink.security.BCloudTrustManager;
import com.tridium.platcrypto.core.BCertManagerService;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;

@NiagaraType
@NiagaraProperty(name="certificateAlias", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(name="BFacets.SECURITY", value="true")})
public class BCertTrustMapping
extends BAbstractTrustMapping {
    @Generated
    public static final Property certificateAlias = BCertTrustMapping.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BCertTrustMapping.class);
    protected static final Logger log = Logger.getLogger("cloudLink.security");

    @Generated
    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    @Generated
    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudTrustManager;
    }

    @Override
    public VerificationKeyResolver getKeyResolver() {
        try {
            BCertManagerService service = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
            X509Certificate certificate = service.getUserTrustStore().getCertificate(this.getCertificateAlias());
            if (certificate != null) {
                certificate.checkValidity();
                X509VerificationKeyResolver resolver = new X509VerificationKeyResolver(new X509Certificate[]{certificate});
                resolver.setTryAllOnNoThumbHeader(true);
                return resolver;
            }
            log.warning("Trust store mapping certificate " + this.getCertificateAlias() + " not found.");
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Trust store mapping certificate verification failed for " + this.getCertificateAlias(), log.isLoggable(Level.FINE) ? ex : null);
        }
        return null;
    }
}

