/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter.strict;

import biweekly.util.Duration;
import biweekly.util.ICalDate;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.reverter.IVEventReverter;
import java.util.Calendar;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;

public class TimeScheduleReverter
implements IVEventReverter<ScheduleVEvent> {
    @Override
    public BAbstractSchedule revert(ScheduleVEvent event) {
        AlwaysEffective alwaysEffective;
        BValue effectiveValue;
        ICalDate end;
        if (event == null) {
            return null;
        }
        ICalDate start = (ICalDate)event.getDateStart().getValue();
        BTime startTime = BTime.DEFAULT;
        if (start.hasTime()) {
            Calendar cals = Calendar.getInstance();
            cals.setTime(start);
            startTime = BTime.make((int)cals.get(11), (int)cals.get(12), (int)cals.get(13));
        }
        BTime endTime = BTime.DEFAULT;
        ICalDate iCalDate = end = event.getDateEnd() != null ? (ICalDate)event.getDateEnd().getValue() : null;
        if (end != null && end.hasTime()) {
            Calendar cale = Calendar.getInstance();
            cale.setTime(end);
            endTime = BTime.make((int)cale.get(11), (int)cale.get(12), (int)cale.get(13));
        } else if (event.getDuration() != null) {
            Duration duration = (Duration)event.getDuration().getValue();
            BRelTime relDuration = BRelTime.make((long)duration.toMillis());
            endTime = startTime.add(relDuration);
        }
        BTimeSchedule timeSchedule = new BTimeSchedule(startTime, endTime);
        EffectiveValue propValue = event.getEffectiveValue();
        if (propValue != null && (effectiveValue = propValue.getBvalue()) != null) {
            timeSchedule.setEffectiveValue((BStatusValue)BStatusValue.make((BObject)effectiveValue));
        }
        if ((alwaysEffective = event.getAlwaysEffective()) != null) {
            timeSchedule.setAlwaysEffective(((Boolean)alwaysEffective.getValue()).booleanValue());
        }
        return timeSchedule;
    }
}

