/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter.strict;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.reverter.IVEventReverter;
import java.util.List;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeekOfMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.schedule.BYearSchedule;
import javax.baja.util.BEnumSet;

public class DateScheduleReverter
implements IVEventReverter<ScheduleVEvent> {
    @Override
    public BAbstractSchedule revert(ScheduleVEvent event) {
        int year = PropertyEncoder.getSingleton(event.getYear());
        List<Integer> months = ConverterUtils.getValues(event.getMonth());
        List<Integer> days = ConverterUtils.getValues(event.getDayOfMonth());
        List<Integer> dows = ConverterUtils.getValues(event.getDayOfWeek());
        List<Integer> woms = ConverterUtils.getValues(event.getWeekOfMonth());
        String scheduleType = (String)event.getNiagaraClass().getValue();
        int[] nMonths = months.stream().mapToInt(Integer::intValue).toArray();
        BMonthSchedule monthSchedule = new BMonthSchedule();
        monthSchedule.setSet(BEnumSet.make((int[])nMonths));
        int[] nDays = days.stream().mapToInt(Integer::intValue).toArray();
        BDayOfMonthSchedule daySchedule = new BDayOfMonthSchedule();
        daySchedule.setSet(BEnumSet.make((int[])nDays));
        int[] nDows = dows.stream().mapToInt(Integer::intValue).toArray();
        BWeekdaySchedule weekdaySchedule = new BWeekdaySchedule();
        weekdaySchedule.setSet(BEnumSet.make((int[])nDows));
        int[] nWoms = woms.stream().mapToInt(Integer::intValue).toArray();
        BWeekOfMonthSchedule womSchedule = new BWeekOfMonthSchedule();
        womSchedule.setSet(BEnumSet.make((int[])nWoms));
        if (CloudLinkConstants.DATE_SCHEDULE_TS.equals(scheduleType)) {
            BDateSchedule dateSchedule = new BDateSchedule();
            dateSchedule.setYear(year);
            dateSchedule.setMonthSchedule(monthSchedule);
            dateSchedule.setDaySchedule(daySchedule);
            dateSchedule.setWeekdaySchedule(weekdaySchedule);
            return dateSchedule;
        }
        if (CloudLinkConstants.WEEK_AND_DAY_SCHEDULE_TS.equals(scheduleType)) {
            BWeekAndDaySchedule wndSchedule = new BWeekAndDaySchedule();
            wndSchedule.setMonths(monthSchedule);
            wndSchedule.setWeekdays(weekdaySchedule);
            wndSchedule.setWeeksOfMonth(womSchedule);
            return wndSchedule;
        }
        BCustomSchedule customSchedule = new BCustomSchedule();
        BYearSchedule yearSchedule = new BYearSchedule();
        yearSchedule.setYear(year);
        customSchedule.setMonths(monthSchedule);
        customSchedule.setDaysOfMonth(daySchedule);
        customSchedule.setWeekdays(weekdaySchedule);
        customSchedule.setWeeksOfMonth(womSchedule);
        return customSchedule;
    }
}

