/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.component.VEvent;
import biweekly.property.RecurrenceRule;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffective;
import com.tridium.cloudLink.schedule.plugin.DayOfMonth;
import com.tridium.cloudLink.schedule.plugin.DayOfWeek;
import com.tridium.cloudLink.schedule.plugin.EffectiveValue;
import com.tridium.cloudLink.schedule.plugin.Month;
import com.tridium.cloudLink.schedule.plugin.NiagaraClass;
import com.tridium.cloudLink.schedule.plugin.Parent;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeEndMonth;
import com.tridium.cloudLink.schedule.plugin.RangeEndYear;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfWeek;
import com.tridium.cloudLink.schedule.plugin.RangeStartMonth;
import com.tridium.cloudLink.schedule.plugin.RangeStartYear;
import com.tridium.cloudLink.schedule.plugin.WeekOfMonth;
import com.tridium.cloudLink.schedule.plugin.Year;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ScheduleVEvent
extends VEvent {
    public static final ICalDate NO_DATE = new ICalDate(new Date(0L));
    public static final ICalDate NO_END_DATE = new ICalDate(new Date(Long.MAX_VALUE));

    public ScheduleVEvent() {
    }

    public ScheduleVEvent(ScheduleVEvent original) {
        super(original);
    }

    public AlwaysEffective getAlwaysEffective() {
        return this.getProperty(AlwaysEffective.class);
    }

    public void setAlwaysEffective(AlwaysEffective alwaysEffective) {
        this.setProperty(AlwaysEffective.class, alwaysEffective);
    }

    public DayOfMonth getDayOfMonth() {
        return this.getProperty(DayOfMonth.class);
    }

    public void setDayOfMonth(DayOfMonth day) {
        this.setProperty(DayOfMonth.class, day);
    }

    public DayOfWeek getDayOfWeek() {
        return this.getProperty(DayOfWeek.class);
    }

    public void setDayOfWeek(DayOfWeek dow) {
        this.setProperty(DayOfWeek.class, dow);
    }

    public NiagaraClass getNiagaraClass() {
        return this.getProperty(NiagaraClass.class);
    }

    public void setNiagaraClass(NiagaraClass niagaraClass) {
        this.setProperty(NiagaraClass.class, niagaraClass);
    }

    public EffectiveValue getEffectiveValue() {
        return this.getProperty(EffectiveValue.class);
    }

    public void setEffectiveValue(EffectiveValue effectiveValue) {
        this.setProperty(EffectiveValue.class, effectiveValue);
    }

    public Month getMonth() {
        return this.getProperty(Month.class);
    }

    public void setMonth(Month month) {
        this.setProperty(Month.class, month);
    }

    public Parent getParent() {
        return this.getProperty(Parent.class);
    }

    public void setParent(Parent parent) {
        this.setProperty(Parent.class, parent);
    }

    public RangeEndDayOfMonth getRangeEndDayOfMonth() {
        return this.getProperty(RangeEndDayOfMonth.class);
    }

    public void setRangeEndDayOfMonth(RangeEndDayOfMonth day) {
        this.setProperty(RangeEndDayOfMonth.class, day);
    }

    public RangeEndDayOfWeek getRangeEndDayOfWeek() {
        return this.getProperty(RangeEndDayOfWeek.class);
    }

    public void setRangeEndDayOfWeek(RangeEndDayOfWeek dow) {
        this.setProperty(RangeEndDayOfWeek.class, dow);
    }

    public RangeEndMonth getRangeEndMonth() {
        return this.getProperty(RangeEndMonth.class);
    }

    public void setRangeEndMonth(RangeEndMonth day) {
        this.setProperty(RangeEndMonth.class, day);
    }

    public RangeEndYear getRangeEndYear() {
        return this.getProperty(RangeEndYear.class);
    }

    public void setRangeEndYear(RangeEndYear day) {
        this.setProperty(RangeEndYear.class, day);
    }

    public RangeStartDayOfMonth getRangeStartDayOfMonth() {
        return this.getProperty(RangeStartDayOfMonth.class);
    }

    public void setRangeStartDayOfMonth(RangeStartDayOfMonth day) {
        this.setProperty(RangeStartDayOfMonth.class, day);
    }

    public RangeStartDayOfWeek getRangeStartDayOfWeek() {
        return this.getProperty(RangeStartDayOfWeek.class);
    }

    public void setRangeStartDayOfWeek(RangeStartDayOfWeek dow) {
        this.setProperty(RangeStartDayOfWeek.class, dow);
    }

    public RangeStartMonth getRangeStartMonth() {
        return this.getProperty(RangeStartMonth.class);
    }

    public void setRangeStartMonth(RangeStartMonth day) {
        this.setProperty(RangeStartMonth.class, day);
    }

    public RangeStartYear getRangeStartYear() {
        return this.getProperty(RangeStartYear.class);
    }

    public void setRangeStartYear(RangeStartYear day) {
        this.setProperty(RangeStartYear.class, day);
    }

    public WeekOfMonth getWeekOfMonth() {
        return this.getProperty(WeekOfMonth.class);
    }

    public void setWeekOfMonth(WeekOfMonth wom) {
        this.setProperty(WeekOfMonth.class, wom);
    }

    public Year getYear() {
        return this.getProperty(Year.class);
    }

    public void setYear(Year year) {
        this.setProperty(Year.class, year);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        super.validate(components, version, warnings);
        this.checkRequiredCardinality(warnings, EffectiveValue.class, NiagaraClass.class, Parent.class);
        this.checkOptionalCardinality(warnings, AlwaysEffective.class);
        NiagaraClass niagaraClass = this.getNiagaraClass();
        if (niagaraClass != null) {
            String propertyValue = (String)niagaraClass.getValue();
            if (CloudLinkConstants.DATE_RANGE_SCHEDULE_TS.equals(propertyValue)) {
                this.checkRequiredCardinality(warnings, RangeStartYear.class, RangeStartMonth.class, RangeStartDayOfMonth.class, RangeEndYear.class, RangeEndMonth.class, RangeEndDayOfMonth.class);
            } else if (CloudLinkConstants.DATE_SCHEDULE_TS.equals(propertyValue)) {
                this.checkRequiredCardinality(warnings, Year.class, Month.class, DayOfMonth.class);
            }
        }
    }

    public ICalDate getLastOccurrence() {
        ICalDate firstOcurrence = (ICalDate)this.getDateStart().getValue();
        RecurrenceRule recurrenceRule = this.getRecurrenceRule();
        if (recurrenceRule == null) {
            return firstOcurrence;
        }
        Recurrence recurrence = (Recurrence)recurrenceRule.getValue();
        if (recurrence == null) {
            return firstOcurrence;
        }
        ICalDate until = recurrence.getUntil();
        if (until != null) {
            return until;
        }
        Integer count = recurrence.getCount();
        if (count == null) {
            return NO_END_DATE;
        }
        Date last = (Date)this.getDateStart().getValue();
        DateIterator iterator = recurrence.getDateIterator(last, TimeZone.getDefault());
        while (iterator.hasNext()) {
            last = (Date)iterator.next();
        }
        return new ICalDate(last);
    }
}

