/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.util.Duration;
import com.tridium.cloudLink.schedule.plugin.ScanLimit;

public class ScanLimitScribe
extends ICalPropertyScribe<ScanLimit> {
    public ScanLimitScribe() {
        super(ScanLimit.class, "X-TRIDIUM-NIAGARA-SCAN-LIMIT", ICalDataType.DURATION);
    }

    @Override
    protected String _writeText(ScanLimit scanLimit, WriteContext writeContext) {
        Duration duration = (Duration)scanLimit.getValue();
        return duration.toString();
    }

    @Override
    protected ScanLimit _parseText(String value, ICalDataType iCalDataType, ICalParameters iCalParameters, ParseContext parseContext) {
        if (iCalDataType != ICalDataType.DURATION) {
            throw new CannotParseException(ICalDataType.DURATION + " expected but found " + iCalDataType.toString());
        }
        try {
            Duration duration = Duration.parse(value);
            return this.newInstance(duration, parseContext.getVersion());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotParseException(ICalDataType.DURATION + " format expected but found " + value);
        }
    }

    protected ScanLimit newInstance(Duration duration, ICalVersion iCalVersion) {
        return new ScanLimit(duration);
    }
}

