/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.text.ICalReader;
import biweekly.io.text.ICalWriter;
import biweekly.property.ICalProperty;
import com.tridium.cloudLink.schedule.plugin.AlwaysEffectiveScribe;
import com.tridium.cloudLink.schedule.plugin.CalNameScribe;
import com.tridium.cloudLink.schedule.plugin.CleanupExpiredEventsScribe;
import com.tridium.cloudLink.schedule.plugin.DayOfMonthScribe;
import com.tridium.cloudLink.schedule.plugin.DayOfWeekScribe;
import com.tridium.cloudLink.schedule.plugin.DefaultOutputScribe;
import com.tridium.cloudLink.schedule.plugin.EffectiveValueScribe;
import com.tridium.cloudLink.schedule.plugin.FacetsScribe;
import com.tridium.cloudLink.schedule.plugin.MonthScribe;
import com.tridium.cloudLink.schedule.plugin.NiagaraClassScribe;
import com.tridium.cloudLink.schedule.plugin.ParentScribe;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfMonthScribe;
import com.tridium.cloudLink.schedule.plugin.RangeEndDayOfWeekScribe;
import com.tridium.cloudLink.schedule.plugin.RangeEndMonthScribe;
import com.tridium.cloudLink.schedule.plugin.RangeEndYearScribe;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfMonthScribe;
import com.tridium.cloudLink.schedule.plugin.RangeStartDayOfWeekScribe;
import com.tridium.cloudLink.schedule.plugin.RangeStartMonthScribe;
import com.tridium.cloudLink.schedule.plugin.RangeStartYearScribe;
import com.tridium.cloudLink.schedule.plugin.ScanLimitScribe;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendarScribe;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEventScribe;
import com.tridium.cloudLink.schedule.plugin.UnionScribe;
import com.tridium.cloudLink.schedule.plugin.WeekOfMonthScribe;
import com.tridium.cloudLink.schedule.plugin.YearScribe;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public final class PluginUtils {
    public static final Set<Supplier<ICalComponentScribe<? extends ICalComponent>>> COMP_PLUGINS = new HashSet<Supplier<ICalComponentScribe<? extends ICalComponent>>>();
    public static final Set<Supplier<ICalPropertyScribe<? extends ICalProperty>>> PROP_PLUGINS = new HashSet<Supplier<ICalPropertyScribe<? extends ICalProperty>>>();

    private PluginUtils() {
    }

    @SafeVarargs
    public static void checkStandardRequired(ICalComponent component, List<ValidationWarning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = component.getProperties(clazz);
            if (!props.isEmpty()) continue;
            warnings.add(new ValidationWarning(2, clazz.getSimpleName()));
        }
    }

    public static void registerPlugins(ICalReader reader) {
        COMP_PLUGINS.forEach(s -> reader.registerScribe((ICalComponentScribe)s.get()));
        PROP_PLUGINS.forEach(s -> reader.registerScribe((ICalPropertyScribe)s.get()));
    }

    public static void registerPlugins(ICalWriter writer) {
        COMP_PLUGINS.forEach(s -> writer.registerScribe((ICalComponentScribe)s.get()));
        PROP_PLUGINS.forEach(s -> writer.registerScribe((ICalPropertyScribe)s.get()));
    }

    static {
        COMP_PLUGINS.add(() -> new ScheduleVCalendarScribe());
        COMP_PLUGINS.add(() -> new ScheduleVEventScribe());
        PROP_PLUGINS.add(() -> new AlwaysEffectiveScribe());
        PROP_PLUGINS.add(() -> new CalNameScribe());
        PROP_PLUGINS.add(() -> new CleanupExpiredEventsScribe());
        PROP_PLUGINS.add(() -> new DayOfMonthScribe());
        PROP_PLUGINS.add(() -> new DayOfWeekScribe());
        PROP_PLUGINS.add(() -> new DefaultOutputScribe());
        PROP_PLUGINS.add(() -> new EffectiveValueScribe());
        PROP_PLUGINS.add(() -> new FacetsScribe());
        PROP_PLUGINS.add(() -> new MonthScribe());
        PROP_PLUGINS.add(() -> new NiagaraClassScribe());
        PROP_PLUGINS.add(() -> new ParentScribe());
        PROP_PLUGINS.add(() -> new RangeEndDayOfMonthScribe());
        PROP_PLUGINS.add(() -> new RangeEndDayOfWeekScribe());
        PROP_PLUGINS.add(() -> new RangeEndMonthScribe());
        PROP_PLUGINS.add(() -> new RangeEndYearScribe());
        PROP_PLUGINS.add(() -> new RangeStartDayOfMonthScribe());
        PROP_PLUGINS.add(() -> new RangeStartDayOfWeekScribe());
        PROP_PLUGINS.add(() -> new RangeStartMonthScribe());
        PROP_PLUGINS.add(() -> new RangeStartYearScribe());
        PROP_PLUGINS.add(() -> new ScanLimitScribe());
        PROP_PLUGINS.add(() -> new UnionScribe());
        PROP_PLUGINS.add(() -> new WeekOfMonthScribe());
        PROP_PLUGINS.add(() -> new YearScribe());
    }
}

