/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ListProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class IntervalProperty
extends ListProperty<Integer> {
    protected Integer min;
    protected Integer max;

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    protected IntervalProperty(Integer min, Integer max, List<Integer> values) {
        super(values);
        this.min = min;
        this.max = max;
    }

    protected IntervalProperty(Integer min, Integer max, Integer ... values) {
        super(values);
        this.min = min;
        this.max = max;
    }

    protected IntervalProperty(Integer min, Integer max, int[] values) {
        super(Arrays.stream(values).boxed().collect(Collectors.toList()));
        this.min = min;
        this.max = max;
    }

    protected IntervalProperty(Integer min, Integer max, String values) {
        super(values == null || values.isEmpty() ? Collections.emptyList() : Arrays.stream(values.split(",")).mapToInt(Integer::valueOf).boxed().collect(Collectors.toList()));
        this.min = min;
        this.max = max;
    }

    protected IntervalProperty(IntervalProperty original) {
        super(original == null ? new ListProperty() : original);
        if (original != null) {
            this.min = original.getMin();
            this.max = original.getMax();
        }
    }

    public int[] getUnboxedValues() {
        return this.getValues().stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        for (Integer value : this.values) {
            if (value >= this.min && value <= this.max) continue;
            warnings.add(new ValidationWarning(String.format("Interval value out of bounds %s not in [%s, %s]", value, this.min, this.max)));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        IntervalProperty other = (IntervalProperty)obj;
        if (this.max == null) {
            return other.max == null;
        }
        if (this.min == null) {
            return other.min == null;
        }
        if (!this.max.equals(other.max)) {
            return false;
        }
        return this.min.equals(other.min);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        return result;
    }
}

