/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalDataType;
import biweekly.component.ICalComponent;
import biweekly.property.RawProperty;
import biweekly.util.Duration;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.plugin.IntervalProperty;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

public class PropertyEncoder {
    public static final String ICAL_PROPERTY_SYNTAX = "(?m)(?s)([^;]*)(;TYPESPEC=.*)?;VALUE=([^:]*):(.*)";
    public static final Pattern ICAL_PROPERTY_PATTERN = Pattern.compile("(?m)(?s)([^;]*)(;TYPESPEC=.*)?;VALUE=([^:]*):(.*)");
    public static final String ICAL_ENUM_PROPERTY_SYNTAX = "(?m)(?s)(.*);TYPESPEC=(.*);ENUM-RANGE=(.*);VALUE=INTEGER:(.*)";
    public static final Pattern ICAL_ENUM_PROPERTY_PATTERN = Pattern.compile("(?m)(?s)(.*);TYPESPEC=(.*);ENUM-RANGE=(.*);VALUE=INTEGER:(.*)");
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public static void encode(String name, BValue value, ICalComponent component) throws IOException {
        if (value instanceof BIBoolean) {
            component.setExperimentalProperty(name, ICalDataType.BOOLEAN, value.toString());
        } else if (value instanceof BInteger) {
            component.setExperimentalProperty(name, ICalDataType.INTEGER, ((BInteger)value).encodeToString());
        } else if (value instanceof BFloat || value instanceof BDouble) {
            RawProperty prop = component.setExperimentalProperty(name, ICalDataType.FLOAT, ((BNumber)value).encodeToString());
            prop.addParameter("TYPESPEC", value.getType().getTypeSpec().encodeToString());
        } else if (value instanceof BEnum) {
            BTypeSpec spec = value.getType().getTypeSpec();
            BEnum enumValue = (BEnum)value;
            RawProperty prop = component.setExperimentalProperty(name, ICalDataType.INTEGER, String.valueOf(enumValue.getOrdinal()));
            prop.addParameter("TYPESPEC", spec.encodeToString());
            prop.addParameter("ENUM-RANGE", enumValue.getRange().encodeToStringExpanded());
        } else if (value instanceof BRelTime) {
            Duration duration = Duration.fromMillis(((BRelTime)value).getMillis());
            component.setExperimentalProperty(name, ICalDataType.DURATION, duration.toString());
        } else {
            component.setExperimentalProperty(name, ICalDataType.TEXT, value.toString());
        }
    }

    public static BValue decode(RawProperty property) {
        if (property != null) {
            ICalDataType dataType = property.getDataType();
            String typeSpecParam = property.getParameter("TYPESPEC");
            if (dataType == ICalDataType.INTEGER) {
                if (typeSpecParam == null) {
                    return BInteger.make((String)property.getValue());
                }
                String typeSpec = PropertyEncoder.getUnquotedValue(typeSpecParam);
                String enumRangeParam = property.getParameter("ENUM-RANGE");
                String range = PropertyEncoder.getUnquotedValue(enumRangeParam);
                return PropertyEncoder.parseEnumProperty(typeSpec, range, property.getValue());
            }
            if (dataType == ICalDataType.BOOLEAN) {
                return BBoolean.make((String)property.getValue());
            }
            if (dataType == ICalDataType.FLOAT) {
                String typeSpec = PropertyEncoder.getUnquotedValue(typeSpecParam);
                if (CloudLinkConstants.FLOAT_TS.equals(typeSpec)) {
                    return BFloat.make((String)property.getValue());
                }
                return BDouble.make((String)property.getValue());
            }
            if (dataType == ICalDataType.DURATION) {
                try {
                    Duration duration = Duration.parse(property.getValue());
                    return BRelTime.make((long)duration.toMillis());
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.INFO, "Invalid duration: " + property.getValue(), log.isLoggable(Level.FINE) ? ex : null);
                    return BRelTime.DEFAULT;
                }
            }
            return BString.make((String)property.getValue());
        }
        return null;
    }

    public static int getSingleton(IntervalProperty property) {
        if (property == null) {
            return -1;
        }
        List values = property.getValues();
        return values == null || values.isEmpty() ? -1 : (Integer)values.get(0);
    }

    public static BEnum parseEnumProperty(String typeSpec, String enumRange, String value) {
        try {
            Object obj;
            Type t = BTypeSpec.make((String)typeSpec).getResolvedType();
            Class clazz = t.getTypeClass();
            int ordinal = Integer.parseInt(value);
            if (t.equals(BDynamicEnum.TYPE)) {
                BEnumRange range = PropertyEncoder.buildEnumRange(enumRange);
                Method maker = clazz.getMethod("make", Integer.TYPE, BEnumRange.class);
                obj = maker.invoke(null, ordinal, range);
            } else {
                Method maker = clazz.getMethod("make", Integer.TYPE);
                obj = maker.invoke(null, ordinal);
            }
            return (BEnum)obj;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | TypeNotFoundException ex) {
            throw new IllegalArgumentException(String.format("Cannot build enum object from encoding %s:%s:%s", typeSpec, enumRange, value));
        }
    }

    private static BEnumRange buildEnumRange(String enumRange) {
        if (enumRange == null) {
            throw new IllegalArgumentException("Invalid enum range");
        }
        String rangeValues = enumRange.substring(1, enumRange.length() - 1);
        if (rangeValues.isEmpty()) {
            return BEnumRange.DEFAULT;
        }
        String[] parts = rangeValues.split(",");
        int numValues = parts.length;
        int[] ordinals = new int[numValues];
        String[] tags = new String[numValues];
        try {
            for (int i = 0; i < numValues; ++i) {
                String[] subparts = parts[i].split("=");
                tags[i] = subparts[0];
                ordinals[i] = Integer.parseInt(subparts[1]);
            }
            return BEnumRange.make((int[])ordinals, (String[])tags);
        }
        catch (NumberFormatException e) {
            log.log(Level.INFO, "Invalid enum ordinal format in EnumRange definition " + enumRange, e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.log(Level.INFO, "Invalid enum tag in EnumRange definition " + enumRange, e);
        }
        return BEnumRange.NULL;
    }

    public static String getUnquotedValue(String quoted) {
        if (quoted == null) {
            return null;
        }
        if (quoted.startsWith("\"") || quoted.startsWith("'")) {
            return quoted.substring(1, quoted.length() - 1);
        }
        return quoted;
    }
}

