/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.EnumSetScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.DayOfMonth;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;

public class DayOfMonthScheduleConverter
extends EnumSetScheduleConverter {
    public DayOfMonthScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDayOfMonthSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DayOfMonthScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BDayOfMonthSchedule dom = (BDayOfMonthSchedule)schedule;
        ScheduleVEvent event = new ScheduleVEvent();
        ConverterUtils.assignUid((BAbstractSchedule)dom, event);
        event.setDayOfMonth(new DayOfMonth(dom.getSet().getOrdinals()));
        event.setSummary(schedule.getDisplayName(null));
        event.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(event);
        return ical;
    }
}

