/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;

public class DateRangeScheduleConverter
extends DefaultScheduleConverter {
    public DateRangeScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDateRangeSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DateRangeScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BDateRangeSchedule range = (BDateRangeSchedule)schedule;
        BDateSchedule start = range.getStart();
        BDateSchedule end = range.getEnd();
        ScheduleVCalendar calStart = this.master.convert((BAbstractSchedule)start, new ScheduleVCalendar());
        ScheduleVCalendar calEnd = this.master.convert((BAbstractSchedule)end, new ScheduleVCalendar());
        for (ScheduleVEvent e : calStart.getScheduleEvents()) {
            e.setSummary("Range " + (String)e.getSummary().getValue());
            ical.addEvent(e);
        }
        for (ScheduleVEvent e : calEnd.getScheduleEvents()) {
            e.setSummary("Range " + (String)e.getSummary().getValue());
            ical.addEvent(e);
        }
        return ical;
    }
}

