/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.DayOfMonth;
import com.tridium.cloudLink.schedule.plugin.DayOfWeek;
import com.tridium.cloudLink.schedule.plugin.Month;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import com.tridium.cloudLink.schedule.plugin.WeekOfMonth;
import com.tridium.cloudLink.schedule.plugin.Year;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class CustomScheduleConverter
extends DefaultScheduleConverter {
    public CustomScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BCustomSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("CustomScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        ScheduleVEvent dateEvent = new ScheduleVEvent();
        ConverterUtils.assignUid(schedule, dateEvent);
        BAbstractSchedule[] kids = (BAbstractSchedule[])schedule.getChildren(BAbstractSchedule.class);
        for (int i = 0; i < kids.length; ++i) {
            ScheduleVCalendar ci = this.master.convert(kids[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : ci.getScheduleEvents()) {
                if (e.getYear() != null) {
                    dateEvent.setYear(new Year(e.getYear()));
                }
                if (e.getMonth() != null) {
                    dateEvent.setMonth(new Month(e.getMonth()));
                }
                if (e.getDayOfMonth() != null) {
                    dateEvent.setDayOfMonth(new DayOfMonth(e.getDayOfMonth()));
                }
                if (e.getDayOfWeek() != null) {
                    dateEvent.setDayOfWeek(new DayOfWeek(e.getDayOfWeek()));
                }
                if (e.getWeekOfMonth() == null) continue;
                dateEvent.setWeekOfMonth(new WeekOfMonth(e.getWeekOfMonth()));
            }
        }
        dateEvent.setSummary(schedule.getDisplayName((Context)new BasicContext()));
        ical.addEvent(dateEvent);
        return ical;
    }
}

