/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import com.tridium.cloudLink.schedule.converter.ControlScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import com.tridium.cloudLink.schedule.plugin.ScheduleVCalendar;
import com.tridium.cloudLink.schedule.plugin.ScheduleVEvent;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class CalendarScheduleConverter
extends ControlScheduleConverter {
    public CalendarScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BCalendarSchedule;
    }

    @Override
    public ScheduleVCalendar convert(BAbstractSchedule schedule, ScheduleVCalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("CalendarScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BCalendarSchedule calendarSchedule = (BCalendarSchedule)schedule;
        BAbstractSchedule[] schedules = calendarSchedule.getSchedules();
        for (int i = 0; i < schedules.length; ++i) {
            ScheduleVCalendar ci = this.master.convert(schedules[i], new ScheduleVCalendar());
            for (ScheduleVEvent e : ci.getScheduleEvents()) {
                e.setSummary(schedule.getDisplayName((Context)new BasicContext()));
                ical.addEvent(e);
            }
        }
        return ical;
    }
}

