/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BScheduleChannel;
import com.tridium.cloudLink.file.IUploadChannelConfig;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicy;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicyContainer;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperty(name="subordinateVersion", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9)
@NiagaraActions(value={@NiagaraAction(name="reverseScheduleSyncDirection", returnType="BCompletableFutureWrapper"), @NiagaraAction(name="exportSchedule", parameterType="BBoolean", defaultValue="BBoolean.FALSE", returnType="BCompletableFutureWrapper", flags=4)})
public class BCloudScheduleExportPolicy
extends BCloudSchedulePolicy
implements BIAlarmSource,
IPropertyValidator {
    @Generated
    public static final Property subordinateVersion = BCloudScheduleExportPolicy.newProperty((int)9, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Action reverseScheduleSyncDirection = BCloudScheduleExportPolicy.newAction((int)0, null);
    @Generated
    public static final Action exportSchedule = BCloudScheduleExportPolicy.newAction((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudScheduleExportPolicy.class);
    private static final int MIN_EXPORT_TIMEOUT = 30;
    public static final int MAX_EXPORT_TIMEOUT = 300;

    @Generated
    public BAbsTime getSubordinateVersion() {
        return (BAbsTime)this.get(subordinateVersion);
    }

    @Generated
    public void setSubordinateVersion(BAbsTime v) {
        this.set(subordinateVersion, (BValue)v, null);
    }

    @Generated
    public BCompletableFutureWrapper reverseScheduleSyncDirection() {
        return (BCompletableFutureWrapper)this.invoke(reverseScheduleSyncDirection, null, null);
    }

    @Generated
    public BCompletableFutureWrapper exportSchedule(BBoolean parameter) {
        return (BCompletableFutureWrapper)this.invoke(exportSchedule, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals(scheduleReference)) {
            this.validateScheduleReference();
            this.setSubordinateVersion(BAbsTime.NULL);
            log.info(() -> String.format("The schedule export policy %s reference has changed, clearing subordinate version property", this.getDisplayName(null)));
        }
    }

    public void doExecute() {
        if (!this.isRunning()) {
            return;
        }
        this.executeInProgress();
        try {
            String errors = this.executeExportPolicy(false);
            if (errors.isEmpty()) {
                this.executeOk();
            } else {
                this.executeFail(errors);
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Schedule export policy %s, unable to export target schedule %s", this.getDisplayName(null), ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            this.executeFail(ex);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(exportSchedule)) {
            if (this.isUnoperational()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, arg, cx);
        }
        if (action.equals(reverseScheduleSyncDirection)) {
            this.getContainer().ifPresent(c -> c.asyncWorkQueue.enqueue((Object)new Invocation((BComponent)this, action, arg, cx)));
            return null;
        }
        return super.post(action, arg, cx);
    }

    private String executeExportPolicy(boolean force) throws ExecutionException, InterruptedException, TimeoutException {
        BScheduleChannel channel = this.getChannel();
        if (channel == null) {
            return lex.getText("schedule.policy.channel.notFound");
        }
        BControlSchedule schedule = this.validateScheduleReference();
        if (schedule == null) {
            log.log(Level.INFO, String.format("Schedule export policy %s failed due to schedule reference validation error", this.getDisplayName(null)));
            return this.getFaultCause();
        }
        BAbsTime modificationTime = (BAbsTime)schedule.get("lastModified");
        if (!force && !modificationTime.isAfter(this.getSubordinateVersion())) {
            log.fine(() -> String.format("Schedule export policy %s, target schedule %s is already up to date", this.getDisplayName(null), this.getScheduleReference().encodeToString()));
            return "";
        }
        channel.exportSchedule(this).get(this.computeExportTimeout(), TimeUnit.SECONDS);
        if (BCloudScheduleExportPolicy.isUploadToCloud(channel.getChannelConfig())) {
            this.setSubordinateVersion(modificationTime);
        }
        return "";
    }

    public BCompletableFutureWrapper doExportSchedule(BBoolean force) {
        if (!this.isRunning()) {
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(false));
        }
        this.executeInProgress();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            String errors = this.executeExportPolicy(force.getBoolean());
            if (errors.isEmpty()) {
                this.executeOk();
                future.complete(true);
            } else {
                this.executeFail(errors);
                future.complete(false);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Failed to export schedule %s - %s", this.getDisplayName(null), ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            future.completeExceptionally(ex);
            this.executeFail(ex);
        }
        return BCompletableFutureWrapper.make(future);
    }

    public BCompletableFutureWrapper doReverseScheduleSyncDirection() {
        if (!this.isRunning()) {
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(false));
        }
        BControlSchedule schedule = this.validateScheduleReference();
        if (schedule == null) {
            log.info(String.format("Schedule export policy %s failed due to schedule reference validation error", this.getDisplayName(null)));
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(false));
        }
        if (BCloudSchedulePolicyContainer.isReadonlyWithImportExtension((BObject)schedule)) {
            log.info(String.format("Reverse sync failed for %s: an import extension is found and the schedule is marked as read-only.", schedule.getSlotPath()));
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(false));
        }
        try {
            this.getContainer().orElseThrow(() -> new BajaRuntimeException("no schedule policy container")).exportToImport(this);
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(true));
        }
        catch (BajaRuntimeException e) {
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(false));
        }
    }

    private long computeExportTimeout() {
        long timeout = 300L;
        BTriggerMode triggerMode = this.getExecutionTime().getTriggerMode();
        if (triggerMode.getType().is(BIntervalTriggerMode.TYPE)) {
            int intervalInSeconds = ((BIntervalTriggerMode)triggerMode.as(BIntervalTriggerMode.class)).getInterval().getSeconds();
            if (intervalInSeconds < 30) {
                timeout = 30L;
            } else if (intervalInSeconds <= 300) {
                timeout = intervalInSeconds * 80 / 100;
            }
        }
        return timeout;
    }

    private static boolean isUploadToCloud(BChannelConfig channelConfig) {
        boolean upload = true;
        if (channelConfig instanceof IUploadChannelConfig) {
            upload = ((IUploadChannelConfig)((Object)channelConfig)).getUploadToCloud();
        }
        return upload;
    }
}

