/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.queue;

import com.tridium.cloudLink.queue.BAbstractMessageQueue;
import com.tridium.cloudLink.queue.BInMemoryMessageQueue;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queueSize", type="long", defaultValue="1048576", facets={@Facet(name="BFacets.MIN", value="1024"), @Facet(name="BFacets.MAX", value="Long.MAX_VALUE")}), @NiagaraProperty(name="weight", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")})})
public class BSingletonInMemoryMessageQueue
extends BAbstractMessageQueue {
    @Generated
    public static final Property queueSize = BSingletonInMemoryMessageQueue.newProperty((int)0, (int)0x100000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1024), (BFacets)BFacets.make((String)"max", (long)Long.MAX_VALUE)));
    @Generated
    public static final Property weight = BSingletonInMemoryMessageQueue.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Type TYPE = Sys.loadType(BSingletonInMemoryMessageQueue.class);
    private static BInMemoryMessageQueue queue;
    private static int instances;
    private static final Object syncObject;

    @Override
    @Generated
    public long getQueueSize() {
        return this.getLong(queueSize);
    }

    @Override
    @Generated
    public void setQueueSize(long v) {
        this.setLong(queueSize, v, null);
    }

    @Override
    @Generated
    public int getWeight() {
        return this.getInt(weight);
    }

    @Override
    @Generated
    public void setWeight(int v) {
        this.setInt(weight, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        super.started();
        Object object = syncObject;
        synchronized (object) {
            ++instances;
            if (queue == null) {
                queue = new BInMemoryMessageQueue();
                queue.start();
                queue.started();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        super.stopped();
        Object object = syncObject;
        synchronized (object) {
            if (--instances == 0 && queue != null) {
                queue.stop();
                queue.stopped();
                queue = null;
            }
        }
    }

    @Override
    public void enqueueMessage(MessageWrapper<? extends IMessage> messageWrapper) {
        if (queue != null) {
            queue.enqueueMessage(messageWrapper);
        }
    }

    @Override
    public void blockingEnqueueMessage(MessageWrapper<? extends IMessage> messageWrapper) {
        if (queue != null) {
            queue.blockingEnqueueMessage(messageWrapper);
        }
    }

    @Override
    public MessageWrapper<? extends IMessage> pullMessage() {
        if (queue != null) {
            return queue.pullMessage();
        }
        return null;
    }

    @Override
    public void retryMessage(String messageId) {
        if (queue != null) {
            queue.retryMessage(messageId);
        }
    }

    @Override
    public void dequeueMessage(String messageId) {
        if (queue != null) {
            queue.dequeueMessage(messageId);
        }
    }

    @Override
    public void clear() {
        if (queue != null) {
            queue.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        if (queue != null) {
            return queue.isEmpty();
        }
        return true;
    }

    @Override
    public int getQueuedMessageCount() {
        if (queue != null) {
            return queue.getQueuedMessageCount();
        }
        return 0;
    }

    @Override
    public int getPendingMessageCount() {
        if (queue != null) {
            return queue.getPendingMessageCount();
        }
        return 0;
    }

    @Override
    public boolean isFull() {
        if (queue != null) {
            return queue.isFull();
        }
        return true;
    }

    @Override
    public boolean isBlocked() {
        if (queue != null) {
            return queue.isBlocked();
        }
        return false;
    }

    static {
        syncObject = new Object();
    }
}

