/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.queue;

import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.queue.BAbstractMessageQueue;
import com.tridium.cloudLink.transport.BHttpTransport;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queueSize", type="long", defaultValue="1048576", facets={@Facet(name="BFacets.MIN", value="1024"), @Facet(name="BFacets.MAX", value="Long.MAX_VALUE")}), @NiagaraProperty(name="weight", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")})})
public class BInMemoryMessageQueue
extends BAbstractMessageQueue {
    @Generated
    public static final Property queueSize = BInMemoryMessageQueue.newProperty((int)0, (int)0x100000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1024), (BFacets)BFacets.make((String)"max", (long)Long.MAX_VALUE)));
    @Generated
    public static final Property weight = BInMemoryMessageQueue.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Type TYPE = Sys.loadType(BInMemoryMessageQueue.class);
    private final ConcurrentLinkedDeque<MessageWrapper<? extends IMessage>> queue = new ConcurrentLinkedDeque();
    private final Map<String, MessageWrapper<? extends IMessage>> pendingSet = new ConcurrentHashMap<String, MessageWrapper<? extends IMessage>>();
    private final ReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private CompletableFuture<Void> enqueueFuture;
    private long dataSize;
    private long queueDataSizeErrorCount;
    private long totalQueueDataSizeRecalculationTime;
    private static final String IN_MEM = "In-Mem-MsgQ";
    private static final char COLON = ':';
    private static final Logger log = Logger.getLogger("cloudLink.queue.inMemory");

    @Override
    @Generated
    public long getQueueSize() {
        return this.getLong(queueSize);
    }

    @Override
    @Generated
    public void setQueueSize(long v) {
        this.setLong(queueSize, v, null);
    }

    @Override
    @Generated
    public int getWeight() {
        return this.getInt(weight);
    }

    @Override
    @Generated
    public void setWeight(int v) {
        this.setInt(weight, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInMemoryMessageQueue() {
    }

    public BInMemoryMessageQueue(int queueSize) {
        this.setQueueSize(queueSize);
    }

    public void started() throws Exception {
        super.started();
        this.queue.clear();
        this.pendingSet.clear();
        this.dataSize = 0L;
    }

    public void stopped() throws Exception {
        this.clear();
        super.stopped();
    }

    @Override
    public void enqueueMessage(MessageWrapper<? extends IMessage> messageWrapper) {
        log.finer(() -> "entering enqueueMessage for " + messageWrapper.getMessageId());
        if (this.isFull()) {
            String transportType = ((BTransportConfig)this.getParent()).getTransportType();
            messageWrapper.getMessageFuture().completeExceptionally(new IOException(String.format("%s %s", transportType, "Transport Queue is full, try again later.")));
            log.finer(() -> "exiting enqueueMessage, queue full enqueue failed for " + messageWrapper.getMessageId());
            return;
        }
        this.doEnqueue(messageWrapper, "enqueueMessage");
    }

    @Override
    public void blockingEnqueueMessage(MessageWrapper<? extends IMessage> messageWrapper) {
        log.finer(() -> "entering blockingEnqueueMessage for " + messageWrapper.getMessageId());
        while (this.isFull()) {
            CompletableFuture<Void> localEnqueueFuture;
            log.fine(() -> "The queue is full, blocking.");
            this.reentrantLock.writeLock().lock();
            try {
                if (this.enqueueFuture == null) {
                    this.enqueueFuture = new CompletableFuture();
                }
                localEnqueueFuture = this.enqueueFuture;
            }
            finally {
                this.reentrantLock.writeLock().unlock();
            }
            try {
                localEnqueueFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | CancellationException ex) {
                log.log(Level.FINE, "interrupted waiting on enqueue future exiting", ex);
                messageWrapper.getMessageFuture().completeExceptionally(ex);
                return;
            }
            catch (ExecutionException ex) {
                log.log(Level.FINE, "exception waiting on enqueue future exiting", ex);
                messageWrapper.getMessageFuture().completeExceptionally(ex);
                return;
            }
            catch (TimeoutException ex) {
                log.log(Level.FINE, "timeout waiting on enqueue future", ex);
            }
        }
        this.doEnqueue(messageWrapper, "blockingEnqueueMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnqueue(MessageWrapper<? extends IMessage> messageWrapper, String methodName) {
        if (messageWrapper.getMessage() instanceof HttpRequestMessage) {
            try {
                BHttpTransport.checkPermission((HttpRequestMessage)messageWrapper.getMessage());
            }
            catch (SecurityException ex) {
                messageWrapper.getMessageFuture().completeExceptionally(ex);
                log.finer(() -> "exiting " + methodName + ", caller has insufficient privileges to send HTTP request with id " + messageWrapper.getMessageId());
                return;
            }
        }
        this.reentrantLock.writeLock().lock();
        try {
            this.queue.addLast(messageWrapper);
            this.dataSize += (long)messageWrapper.getMessage().getLength();
        }
        finally {
            this.reentrantLock.writeLock().unlock();
        }
        log.finer(() -> "exiting " + methodName + " for " + messageWrapper.getMessageId());
    }

    @Override
    public MessageWrapper<? extends IMessage> pullMessage() {
        log.finer(() -> "entering pullMessage");
        MessageWrapper<? extends IMessage> messageWrapper = this.queue.pollFirst();
        if (messageWrapper == null) {
            log.finer(() -> "exiting pullMessage, queue empty");
            return null;
        }
        this.pendingSet.put(messageWrapper.getMessageId(), messageWrapper);
        log.finer(() -> "exiting pullMessage, returning message " + messageWrapper.getMessageId());
        return messageWrapper;
    }

    @Override
    public void retryMessage(String messageId) {
        log.finer(() -> "entering retryMessage for " + messageId);
        boolean messageFound = false;
        MessageWrapper<? extends IMessage> messageWrapper = this.pendingSet.remove(messageId);
        if (messageWrapper != null) {
            this.queue.addFirst(messageWrapper);
            messageFound = true;
        }
        if (messageFound) {
            log.finer(() -> "exiting retryMessage, message requeued for " + messageId);
        } else {
            log.finer(() -> "exiting retryMessage, message not found for " + messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeueMessage(String messageId) {
        log.finer(() -> "entering dequeueMessage for " + messageId);
        MessageWrapper<? extends IMessage> messageWrapper = this.pendingSet.remove(messageId);
        if (messageWrapper != null) {
            this.reentrantLock.writeLock().lock();
            try {
                this.dataSize -= (long)messageWrapper.getMessage().getLength();
                if (this.dataSize < 0L) {
                    ++this.queueDataSizeErrorCount;
                    long start = Clock.ticks();
                    this.dataSize = 0L;
                    for (MessageWrapper<? extends IMessage> wrapper : this.queue) {
                        this.dataSize += (long)wrapper.getMessage().getLength();
                    }
                    for (MessageWrapper<? extends IMessage> wrapper : this.pendingSet.values()) {
                        this.dataSize += (long)wrapper.getMessage().getLength();
                    }
                    long recalcTime = Clock.ticks() - start;
                    log.warning(() -> String.format("BMessageQueue, dataSize below zero recalculated queue size in %d ms.", recalcTime));
                    this.totalQueueDataSizeRecalculationTime += recalcTime;
                }
                if (this.enqueueFuture != null) {
                    log.finer("Completing blocking future.");
                    this.enqueueFuture.complete(null);
                    this.enqueueFuture = null;
                }
            }
            finally {
                this.reentrantLock.writeLock().unlock();
            }
            log.finer(() -> "exiting dequeueMessage, for " + messageId);
        } else {
            log.finer(() -> "exiting dequeueMessage, message not found for " + messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        log.finer(() -> "entering clear");
        this.reentrantLock.writeLock().lock();
        try {
            CompletableFuture<IMessageResponse> iMessageResponseCompletableFuture;
            for (MessageWrapper<? extends IMessage> wrapper : this.queue) {
                log.finest(() -> "removing queued message with id " + wrapper.getMessageId());
                iMessageResponseCompletableFuture = wrapper.getMessageFuture();
                if (iMessageResponseCompletableFuture != null) {
                    iMessageResponseCompletableFuture.cancel(true);
                    continue;
                }
                log.info("Clearing message queue and found message without future.");
            }
            for (MessageWrapper<? extends IMessage> wrapper : this.pendingSet.values()) {
                log.finest(() -> "removing pending message with id " + wrapper.getMessageId());
                iMessageResponseCompletableFuture = wrapper.getMessageFuture();
                if (iMessageResponseCompletableFuture != null) {
                    iMessageResponseCompletableFuture.cancel(true);
                    continue;
                }
                log.info("Clearing pending messages and found message without future.");
            }
            this.queue.clear();
            this.pendingSet.clear();
            this.dataSize = 0L;
            if (this.enqueueFuture != null) {
                this.enqueueFuture.cancel(true);
                this.enqueueFuture = null;
            }
        }
        finally {
            this.reentrantLock.writeLock().unlock();
        }
        log.finer(() -> "exiting clear");
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int getQueuedMessageCount() {
        return this.queue.size();
    }

    @Override
    public int getPendingMessageCount() {
        return this.pendingSet.size();
    }

    @Override
    public boolean isFull() {
        this.reentrantLock.readLock().lock();
        try {
            boolean bl = this.getQueueSize() <= this.dataSize;
            return bl;
        }
        finally {
            this.reentrantLock.readLock().unlock();
        }
    }

    @Override
    public boolean isBlocked() {
        this.reentrantLock.readLock().lock();
        try {
            boolean bl = this.enqueueFuture != null;
            return bl;
        }
        finally {
            this.reentrantLock.readLock().unlock();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Message Queue");
        out.prop((Object)"Queued messages", this.queue.size());
        out.prop((Object)"Pending messages", this.pendingSet.size());
        this.reentrantLock.readLock().lock();
        try {
            out.prop((Object)"Current queue data size (bytes)", (double)this.dataSize);
            out.prop((Object)"Queue Data Size Error Count", (double)this.queueDataSizeErrorCount);
            out.prop((Object)"Total Queue Data Size Recalculation time (ms)", (double)this.totalQueueDataSizeRecalculationTime);
        }
        finally {
            this.reentrantLock.readLock().unlock();
        }
        out.endProps();
        super.spy(out);
    }

    public String toString(Context cx) {
        try {
            if (this.isMounted()) {
                return this.getParent().getParent().getParent().getName() + ':' + ((BTransportConfig)this.getParent()).getTransportType() + ':' + IN_MEM;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IN_MEM;
    }
}

