/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.provisioning;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BClientChannelsFolder;
import com.tridium.cloudLink.channel.BMessageChannelConfig;
import com.tridium.cloudLink.provisioning.CloudLinkConfiguration;
import com.tridium.cloudLink.provisioning.ComponentConfiguration;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.BTransportsFolder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="configurationIdentifier", type="BString", defaultValue="BString.DEFAULT")
public class BCloudLinkProvisioning
extends BComponent {
    @Generated
    public static final Property configurationIdentifier = BCloudLinkProvisioning.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudLinkProvisioning.class);
    public static final BCloudLinkProvisioning DEFAULT = new BCloudLinkProvisioning();
    protected static final Logger log = Logger.getLogger("cloudLink.provisioning");

    @Generated
    public String getConfigurationIdentifier() {
        return this.getString(configurationIdentifier);
    }

    @Generated
    public void setConfigurationIdentifier(String v) {
        this.setString(configurationIdentifier, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void configureCCS(CloudLinkConfiguration configuration) {
        BAbstractClientChannel bAbstractClientChannel;
        if (configuration == null) {
            log.info("configureCCS invoked with null configuration");
            return;
        }
        BCloudConnectionService ccs = this.getCloudConnectionService();
        if (ccs == null) {
            log.info("configureCCS unable to locate cloud connection service");
            return;
        }
        BClientAuthenticatorsFolder authenticators = ccs.getAuthenticators();
        for (ComponentConfiguration componentConfiguration : configuration.getAuthenticators()) {
            this.processConfiguration((BComplex)authenticators, componentConfiguration, BAbstractClientAuthenticator.class);
        }
        BTransportsFolder transports = ccs.getTransports();
        for (ComponentConfiguration componentConfiguration : configuration.getTransports()) {
            this.processConfiguration((BComplex)transports, componentConfiguration, BAbstractTransport.class);
        }
        BClientChannelsFolder bClientChannelsFolder = ccs.getChannels();
        for (ComponentConfiguration config : configuration.getChannels()) {
            this.processConfiguration((BComplex)bClientChannelsFolder, config, BAbstractClientChannel.class);
        }
        if (!configuration.getTransports().isEmpty() && (bAbstractClientChannel = bClientChannelsFolder.getChannel("Messaging")) != null) {
            BMessageChannelConfig channelConfig = (BMessageChannelConfig)bAbstractClientChannel.getChannelConfig();
            channelConfig.configureTransports();
        }
        for (ComponentConfiguration config : configuration.getComponents()) {
            this.processConfiguration((BComplex)ccs, config, BValue.class);
        }
        BStation bStation = Sys.getStation();
        if (bStation != null) {
            bStation.save();
        }
    }

    private void processConfiguration(BComplex parent, ComponentConfiguration config, Class<? extends BValue> typeRestriction) {
        Property property = parent.getProperty(config.getName());
        if (property == null) {
            BSimple propertyValue;
            if (parent.isStruct()) {
                log.info(() -> String.format("Skipping addition of dynamic slot %s; cannot add to a BStruct of type %s", config.getName(), parent.getType().getTypeName()));
                return;
            }
            BTypeSpec spec = BTypeSpec.make((String)config.getModule(), (String)config.getType());
            try {
                if (!BCloudLinkProvisioning.isLegalType(spec.getTypeInfo())) {
                    log.warning(() -> String.format("Attempted to install object with forbidden type %s, skipping", spec));
                    return;
                }
                if (spec.getTypeInfo().is(BSimple.TYPE)) {
                    propertyValue = this.makeValue(spec, config.getValue());
                } else {
                    BObject obj = spec.getInstance();
                    if (!typeRestriction.isInstance(obj)) {
                        log.info(() -> String.format("unable to create %s as a %s", spec, typeRestriction.getName()));
                        return;
                    }
                    BComplex complexValue = (BComplex)obj;
                    this.processSlots(config, complexValue);
                    propertyValue = complexValue;
                }
            }
            catch (TypeNotFoundException ex) {
                log.log(Level.WARNING, "Provisioning information contains unknown type " + spec, log.isLoggable(Level.FINE) ? ex : null);
                return;
            }
            BFacets facets = null;
            int flags = 0;
            try {
                facets = BFacets.make((String)config.getFacets());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "error deserializing facets [" + config.getFacets() + ']', log.isLoggable(Level.FINE) ? ex : null);
            }
            if (config.getFlags() != null) {
                flags = Flags.decodeFromString((String)config.getFlags());
            }
            try {
                ((BIPropertyContainer)parent).add(config.getName(), (BValue)propertyValue, flags, facets, null);
            }
            catch (Exception ex) {
                log.log(Level.INFO, "unable to add property [" + config.getName() + "] to parent [" + parent.getName() + ']', log.isLoggable(Level.FINE) ? ex : null);
            }
        } else {
            BTypeSpec typeSpec = BTypeSpec.make((String)config.getModule(), (String)config.getType());
            Type configType = typeSpec.getResolvedType();
            if (!configType.is(property.getType())) {
                log.info(() -> String.format("Configuration type %s:%s does not match type %s of existing property value of %s", config.getModule(), config.getType(), property.getType().getTypeSpec().toString(null), config.getName()));
                return;
            }
            if (property.getType().is(BSimple.TYPE)) {
                parent.set(property, (BValue)this.makeValue(typeSpec, config.getValue()));
            } else {
                BComplex value = parent.get(property).asComplex();
                if (value.getType().is(configType)) {
                    this.processSlots(config, value);
                } else {
                    value = (BComplex)typeSpec.getInstance();
                    this.processSlots(config, value);
                    parent.set(property, (BValue)value);
                }
            }
        }
    }

    private void processSlots(ComponentConfiguration config, BComplex complexValue) {
        for (ComponentConfiguration componentConfiguration : config.getProperties()) {
            this.processConfiguration(complexValue, componentConfiguration, BValue.class);
        }
    }

    protected BCloudConnectionService getCloudConnectionService() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BCloudConnectionService); parent = parent.getParent()) {
        }
        return (BCloudConnectionService)parent;
    }

    protected BSimple makeValue(BTypeSpec spec, Object obj) {
        try {
            if (obj instanceof String) {
                return (BSimple)spec.getInstance().asSimple().decodeFromString((String)obj);
            }
            if (obj instanceof Boolean) {
                return BBoolean.make((boolean)((Boolean)obj));
            }
            if (obj instanceof Double) {
                return BDouble.make((double)((Double)obj));
            }
            if (obj instanceof Integer) {
                return BInteger.make((int)((Integer)obj));
            }
            if (obj instanceof Long) {
                return BLong.make((long)((Long)obj));
            }
            if (obj instanceof Float) {
                return BFloat.make((float)((Float)obj).floatValue());
            }
            return (BSimple)spec.getInstance().asSimple().decodeFromString(obj.toString());
        }
        catch (IOException ex) {
            log.log(Level.INFO, "error deserializing value [" + obj + ']', log.isLoggable(Level.FINE) ? ex : null);
            return spec.getInstance().asSimple();
        }
    }

    private static boolean isLegalType(TypeInfo typeInfo) {
        return !"program".equals(typeInfo.getModuleName());
    }
}

