/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.points;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BPointsChannel;
import com.tridium.cloudLink.points.BPointCovExportPolicy;
import com.tridium.cloudLink.points.BPointExportPolicy;
import com.tridium.cloudLink.util.BCloudPolicyContainer;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultExportPolicy", type="BPointExportPolicy", defaultValue="BPointExportPolicy.make(\"station:|slot:/|neql:n:point and not \" + EXCLUDED.getQName())", flags=256), @NiagaraProperty(name="covExportPolicy", type="BPointCovExportPolicy", defaultValue="new BPointCovExportPolicy()", flags=256), @NiagaraProperty(name="maxConcurrentExportExecutions", type="int", defaultValue="10", flags=7, facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")}), @NiagaraProperty(name="maxConcurrentExecutions", type="int", defaultValue="4", facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")}, override=true)})
@NiagaraActions(value={@NiagaraAction(name="executeAll", flags=256), @NiagaraAction(name="retryFailedExports", flags=256), @NiagaraAction(name="addPolicy")})
public class BPointExportPolicyContainer
extends BCloudPolicyContainer {
    private static final int MIN_THREAD_POOL_SIZE = 1;
    @Generated
    public static final Property defaultExportPolicy = BPointExportPolicyContainer.newProperty((int)256, (BValue)BPointExportPolicy.make("station:|slot:/|neql:n:point and not " + CloudLinkConstants.EXCLUDED.getQName()), null);
    @Generated
    public static final Property covExportPolicy = BPointExportPolicyContainer.newProperty((int)256, (BValue)new BPointCovExportPolicy(), null);
    @Generated
    public static final Property maxConcurrentExportExecutions = BPointExportPolicyContainer.newProperty((int)7, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property maxConcurrentExecutions = BPointExportPolicyContainer.newProperty((int)0, (int)4, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Action executeAll = BPointExportPolicyContainer.newAction((int)256, null);
    @Generated
    public static final Action retryFailedExports = BPointExportPolicyContainer.newAction((int)256, null);
    @Generated
    public static final Action addPolicy = BPointExportPolicyContainer.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPointExportPolicyContainer.class);
    private static final Lexicon LEX = Lexicon.make(BPointExportPolicyContainer.class);
    static final Logger LOGGER = Logger.getLogger("cloudLink.channel.point");

    @Generated
    public BPointExportPolicy getDefaultExportPolicy() {
        return (BPointExportPolicy)this.get(defaultExportPolicy);
    }

    @Generated
    public void setDefaultExportPolicy(BPointExportPolicy v) {
        this.set(defaultExportPolicy, (BValue)v, null);
    }

    @Generated
    public BPointCovExportPolicy getCovExportPolicy() {
        return (BPointCovExportPolicy)this.get(covExportPolicy);
    }

    @Generated
    public void setCovExportPolicy(BPointCovExportPolicy v) {
        this.set(covExportPolicy, (BValue)v, null);
    }

    @Generated
    public int getMaxConcurrentExportExecutions() {
        return this.getInt(maxConcurrentExportExecutions);
    }

    @Generated
    public void setMaxConcurrentExportExecutions(int v) {
        this.setInt(maxConcurrentExportExecutions, v, null);
    }

    @Generated
    public void executeAll() {
        this.invoke(executeAll, null, null);
    }

    @Generated
    public void retryFailedExports() {
        this.invoke(retryFailedExports, null, null);
    }

    @Generated
    public void addPolicy() {
        this.invoke(addPolicy, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected Type getChannelType() {
        return BPointsChannel.TYPE;
    }

    @Override
    protected Type[] getPolicyTypes() {
        return new Type[]{BPointExportPolicy.TYPE};
    }

    @Override
    protected String getWorkerThreadName() {
        return "NcsPointExportWorker";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected int getMinThreadPoolSize() {
        return 1;
    }

    public final BPointsChannel getChannel() {
        return (BPointsChannel)this.getParent();
    }

    Queue getAsyncWorkQueue() {
        return this.asyncWorkQueue;
    }

    public void doAddPolicy() {
        this.add(LEX.getText("points.export.name") + '?', (BValue)BPointExportPolicy.make(new String[0]));
    }

    public void doExecuteAll() {
        BPointExportPolicy[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BPointExportPolicy config : configs = (BPointExportPolicy[])this.getChildren(BPointExportPolicy.class)) {
            if (!config.getEnabled()) continue;
            config.execute();
        }
    }

    public void doRetryFailedExports() {
        BPointExportPolicy[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BPointExportPolicy config : configs = (BPointExportPolicy[])this.getChildren(BPointExportPolicy.class)) {
            if (config.isUnoperational() || !config.isFault()) continue;
            config.execute();
        }
    }
}

