/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.points;

import com.tridium.cloudLink.channel.BPointsChannel;
import com.tridium.cloudLink.points.BPointExportPolicyContainer;
import com.tridium.util.ThrowableUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryResult;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true), @NiagaraProperty(name="customPointQueries", type="BOrdList", defaultValue="BOrdList.NULL", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public class BPointExportPolicy
extends BAbstractDescriptor
implements BIAlarmSource,
Iterator<BIObject> {
    @Generated
    public static final Property executionTime = BPointExportPolicy.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    @Generated
    public static final Property customPointQueries = BPointExportPolicy.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property alarmOnFailure = BPointExportPolicy.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmSourceInfo = BPointExportPolicy.newProperty((int)0, (BValue)BPointExportPolicy.initAlarmSourceInfo(), null);
    @Generated
    public static final Action ackAlarm = BPointExportPolicy.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPointExportPolicy.class);
    protected int queryIndex;
    private Iterator<? extends BIObject> resultIterator;
    private AlarmSupport alarmSupport;
    protected static final Logger log = Logger.getLogger("cloudLink.channel.point");

    @Generated
    public BOrdList getCustomPointQueries() {
        return (BOrdList)this.get(customPointQueries);
    }

    @Generated
    public void setCustomPointQueries(BOrdList v) {
        this.set(customPointQueries, (BValue)v, null);
    }

    @Generated
    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    @Generated
    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BPointExportPolicyContainer;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
    }

    public final BCategoryMask getCategoryMask() {
        return this.getParent() == null ? super.getCategoryMask() : this.getParent().asComponent().getCategoryMask();
    }

    public final BCategoryMask getAppliedCategoryMask() {
        return this.getParent() == null ? super.getAppliedCategoryMask() : this.getParent().asComponent().getAppliedCategoryMask();
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BPointsChannel channel = this.getChannel();
        newStatus = !this.getEnabled() || channel != null && channel.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public static BPointExportPolicy make(String ... queries) {
        BPointExportPolicy policy = new BPointExportPolicy();
        BOrdList queryList = policy.getCustomPointQueries();
        for (String query : queries) {
            queryList = BOrdList.add((BOrdList)queryList, (BOrd)BOrd.make((String)query));
        }
        policy.setCustomPointQueries(queryList);
        policy.setEnabled(false);
        return policy;
    }

    public void doExecute() {
        try {
            if (!this.isRunning()) {
                return;
            }
            this.executeInProgress();
            BIQueryHandler.validateQueryOrds((BOrdList)this.getCustomPointQueries());
            this.queryIndex = 0;
            BPointsChannel channel = this.getChannel();
            if (channel != null) {
                channel.sendPoints(this);
                this.executeOk();
            } else {
                log.info("unable to export points: point channel not found");
                this.executeFail("Point channel not found");
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "unable to export points: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            this.executeFail(ThrowableUtil.dumpToString((Throwable)ex, (int)1));
        }
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BBoolean.make((boolean)BPointExportPolicy.processAlarmAck(this.alarmSupport, ackRequest));
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        ((BPointExportPolicyContainer)this.getParent().as(BPointExportPolicyContainer.class)).getAsyncWorkQueue().enqueue((Object)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        if (this.getStatus().isAlarm()) {
            BPointExportPolicy.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        this.updateStatus();
    }

    public final void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            boolean ackRequired = BPointExportPolicy.processAlarmOffnormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.updateStatus();
    }

    protected BPointsChannel getChannel() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BPointsChannel); parent = parent.getParent()) {
        }
        return (BPointsChannel)parent;
    }

    @Override
    public boolean hasNext() {
        if (this.resultIterator == null && !this.getNextIterator()) {
            return false;
        }
        if (!this.resultIterator.hasNext()) {
            if (this.getNextIterator()) {
                return this.hasNext();
            }
            return false;
        }
        return true;
    }

    @Override
    public BIObject next() {
        return this.resultIterator.next();
    }

    private boolean getNextIterator() {
        BOrdList queries = this.getCustomPointQueries();
        if (this.queryIndex >= queries.size()) {
            return false;
        }
        BOrd queryOrd = queries.get(this.queryIndex++);
        BOrd ord = BOrd.make((BOrd)BOrd.make((String)"local:|station:|slot:/"), (BOrd)queryOrd);
        final BObject queryResult = ord.get();
        if (queryResult == null) {
            return this.getNextIterator();
        }
        this.resultIterator = queryResult.getType().is(BQueryResult.TYPE) ? ((BQueryResult)queryResult).cursor().iterator() : (queryResult.getType().is(BITable.TYPE) ? ((BITable)queryResult).cursor().iterator() : new Iterator<BIObject>(){
            private boolean nextFlag = true;

            @Override
            public boolean hasNext() {
                return this.nextFlag;
            }

            @Override
            public BIObject next() {
                if (this.nextFlag) {
                    this.nextFlag = false;
                    return queryResult;
                }
                throw new NoSuchElementException();
            }
        });
        return true;
    }

    static void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal((Context)null);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    static boolean processAlarmOffnormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process off normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
        return ackRequired;
    }

    static boolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return support.ackAlarm(ackRequest);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process alarm ack: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        try {
            out.startProps("BPointExportPolicy");
            if (this.getCustomPointQueries().size() > 0) {
                out.trTitle((Object)"Custom point queries with count", 2);
                for (BOrd bOrd : this.getCustomPointQueries()) {
                    out.prop((Object)bOrd, (int)this.getQueryResultCount(bOrd));
                }
            }
        }
        finally {
            out.endProps();
        }
        super.spy(out);
    }

    private long getQueryResultCount(BOrd bOrd) {
        long count = 0L;
        try {
            BObject queryResult = bOrd.get();
            if (queryResult.getType().is(BQueryResult.TYPE)) {
                count = ((BQueryResult)queryResult).stream().count();
            } else if (queryResult.getType().is(BITable.TYPE)) {
                count = ((BITable)queryResult).cursor().stream().count();
            } else if (queryResult.isComponent()) {
                ++count;
            }
        }
        catch (BajaRuntimeException ex) {
            log.log(Level.WARNING, String.format("Error while resolving query: %s, %s", bOrd, ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
        }
        return count;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLink:points.export.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLink:points.export.success)%"));
        return asi;
    }
}

