/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.points;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BPointsChannel;
import com.tridium.cloudLink.points.BPointExportPolicy;
import com.tridium.cloudLink.points.CovRecord;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.DEFAULT)", flags=4, override=true), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false", override=true), @NiagaraProperty(name="covBatchDelay", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(250)"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true")})})
@NiagaraAction(name="sendBatchCovValues", returnType="BCompletableFutureWrapper", flags=4)
public class BPointCovExportPolicy
extends BPointExportPolicy {
    @Generated
    public static final Property executionTime = BPointCovExportPolicy.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.DEFAULT), null);
    @Generated
    public static final Property enabled = BPointCovExportPolicy.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property covBatchDelay = BPointCovExportPolicy.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)250L)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    @Generated
    public static final Action sendBatchCovValues = BPointCovExportPolicy.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPointCovExportPolicy.class);
    protected Clock.Ticket covSendTicket;
    protected final List<CovRecord> records = new ArrayList<CovRecord>();
    protected final ReentrantLock covBatchLock = new ReentrantLock();
    private static final CovRecord[] EMPTY_COV_RECORD_ARRAY = new CovRecord[0];

    @Generated
    public BRelTime getCovBatchDelay() {
        return (BRelTime)this.get(covBatchDelay);
    }

    @Generated
    public void setCovBatchDelay(BRelTime v) {
        this.set(covBatchDelay, (BValue)v, null);
    }

    @Generated
    public BCompletableFutureWrapper sendBatchCovValues() {
        return (BCompletableFutureWrapper)this.invoke(sendBatchCovValues, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.getEnabled()) {
            this.updateSubscriptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == customPointQueries && this.getEnabled()) {
            this.updateSubscriptions();
        }
        if (property == enabled || property == BAbstractDescriptor.enabled) {
            if (this.getEnabled()) {
                this.updateSubscriptions();
            } else {
                BOrdList queries = this.getCustomPointQueries();
                this.setCustomPointQueries(BOrdList.NULL);
                this.updateSubscriptions();
                this.setCustomPointQueries(queries);
            }
        }
        if (property.isDynamic()) {
            this.covBatchLock.lock();
            try {
                CovRecord record;
                if (this.covSendTicket == null) {
                    this.covSendTicket = Clock.schedule((BComponent)this, (BRelTime)this.getCovBatchDelay(), (Action)sendBatchCovValues, null);
                }
                if (!this.records.contains(record = new CovRecord(SlotPath.unescape((String)property.getName()), BAbsTime.now(), (BStatusValue)this.get(property)))) {
                    this.records.add(record);
                }
            }
            finally {
                this.covBatchLock.unlock();
            }
        }
    }

    public BCompletableFutureWrapper doSendBatchCovValues() {
        CompletableFuture<Void> rv;
        CovRecord[] recordArray;
        this.setLastAttempt(Clock.time());
        this.executeInProgress();
        this.covBatchLock.lock();
        try {
            recordArray = this.records.toArray(EMPTY_COV_RECORD_ARRAY);
            this.records.clear();
            if (this.covSendTicket != null && !this.covSendTicket.isExpired()) {
                this.covSendTicket.cancel();
            }
            this.covSendTicket = null;
        }
        finally {
            this.covBatchLock.unlock();
        }
        BPointsChannel channel = this.getChannel();
        if (channel == null) {
            log.warning("Point COV export policy unable to find points channel, aborting");
            CompletableFuture rv2 = new CompletableFuture();
            rv2.completeExceptionally(new Exception("Point COV export policy unable to find points channel"));
            return BCompletableFutureWrapper.make(rv2);
        }
        try {
            rv = CompletableFuture.allOf(channel.sendPoints(recordArray).toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY));
        }
        catch (Exception ex2) {
            log.log(Level.INFO, "Unable to send COV update", log.isLoggable(Level.FINE) ? ex2 : null);
            rv = new CompletableFuture();
            rv.completeExceptionally(ex2);
        }
        rv.whenComplete((v, ex) -> {
            if (ex != null) {
                this.executeFail(ex.getMessage());
            } else {
                this.executeOk();
            }
        });
        return BCompletableFutureWrapper.make(rv);
    }

    private void updateSubscriptions() {
        this.queryIndex = 0;
        Property[] properties = this.getDynamicPropertiesArray();
        HashSet<String> validIds = new HashSet<String>();
        while (this.hasNext()) {
            BIObject obj = this.next();
            String id = TagUtil.getCloudIdString((BIObject)obj).orElse(null);
            if (id == null) {
                log.info("Point COV export policy skipping point without cloud id [" + (obj instanceof BINavNode ? ((BINavNode)obj).getNavOrd().toString() : "") + ']');
                continue;
            }
            if (!(obj instanceof BControlPoint)) {
                log.info("Point COV export policy skipping non control point with id [" + id + ']');
                continue;
            }
            BControlPoint value = (BControlPoint)obj;
            Property property = this.getProperty(id = SlotPath.escape((String)id));
            if (property != null) {
                validIds.add(id);
                BLink[] links = this.getLinks((Slot)property);
                if (Arrays.stream(links).anyMatch(l -> l.getSourceComponent() == value)) continue;
                log.info("Point COV export policy found 2 points with same cloud id[" + SlotPath.unescape((String)id) + "], skipping second point.");
            }
            this.add(id, value.getOutStatusValue().newCopy(), 6);
            BLink covLink = new BLink(value.getHandleOrd(), "out", id, true);
            this.add(id + "Link", (BValue)covLink, 6);
        }
        Arrays.stream(properties).filter(p -> p.isDynamic() && !p.getType().is(BLink.TYPE) && (p.getDefaultFlags() & 2) != 0 && !validIds.contains(p.getName())).forEach(p -> this.remove((Property)p));
    }
}

