/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.objectIdentity;

import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.clUtils.util.BHistoryImportHelper;
import com.tridium.clUtils.util.BProxyPointHelper;
import com.tridium.clUtils.util.BProxyPointTagsHelper;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.model.IGetDeviceHistoryId;
import com.tridium.cloudLink.objectIdentity.BAbstractIdentityWorker;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.util.CompUtil;
import com.tridium.util.ComponentTreeCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.point.BProxyExt;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scope", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")", flags=5), @NiagaraProperty(name="componentTypes", type="BVector", defaultValue="new BVector()", flags=5), @NiagaraProperty(name="excludedComponentTypes", type="BVector", defaultValue="new BVector()", flags=5)})
public class BComponentIdentityWorker
extends BAbstractIdentityWorker {
    @Generated
    public static final Property scope = BComponentIdentityWorker.newProperty((int)5, (BValue)BOrd.make((String)"station:|slot:/"), null);
    @Generated
    public static final Property componentTypes = BComponentIdentityWorker.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Property excludedComponentTypes = BComponentIdentityWorker.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BComponentIdentityWorker.class);
    private static final Pattern IGNORED_HISTORY = Pattern.compile(".*_cfg\\d+$");
    protected static final String DRIVERS_ROOT_ORD = "station:|slot:/";
    protected static final String EBI_ID_SLOT_NAME = "id";
    protected static final String HIST_IMPORTS_QUERY = "bql:select from driver:HistoryImport";
    protected static final Map<String, IGetDeviceHistoryId> HISTORY_ID_GENERATOR_MAP = new HashMap<String, IGetDeviceHistoryId>();
    public static final String NIAGARA_NETWORK_TYPE = "niagaraDriver:NiagaraNetwork";
    public static final String BACNET_NETWORK_TYPE = "bacnet:BacnetNetwork";
    public static final String EBI_NETWORK_TYPE = "ebiConnector:EbiConnectorNetwork";
    private static final Logger liclog;
    private static final Logger licdbg;
    private final List<BComponent> needsCloudIdList = new ArrayList<BComponent>();

    @Generated
    public BOrd getScope() {
        return (BOrd)this.get(scope);
    }

    @Generated
    public void setScope(BOrd v) {
        this.set(scope, (BValue)v, null);
    }

    @Generated
    public BVector getComponentTypes() {
        return (BVector)this.get(componentTypes);
    }

    @Generated
    public void setComponentTypes(BVector v) {
        this.set(componentTypes, (BValue)v, null);
    }

    @Generated
    public BVector getExcludedComponentTypes() {
        return (BVector)this.get(excludedComponentTypes);
    }

    @Generated
    public void setExcludedComponentTypes(BVector v) {
        this.set(excludedComponentTypes, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            Map<String, BHistoryImport> importMap = this.processHistoryImports();
            this.processHistories();
            Predicate<BComponent> componentTypeFilter = this.makeComponentPredicate();
            BCloudConnectionService ccs = this.cloudConnectionService();
            try (ComponentTreeCursor cursor = new ComponentTreeCursor(this.getScope().resolve().getComponent(), null);){
                while (cursor.next()) {
                    BValue obj = cursor.get();
                    if (!obj.isComponent()) {
                        log.finest(() -> "Skipping BValue (not a component) --> " + obj.toDebugString());
                        continue;
                    }
                    BComponent component2 = obj.asComponent();
                    if (!componentTypeFilter.test(component2) || CloudLinkTagUtil.entityExcludedFromModel.test((Entity)component2)) {
                        log.finest(() -> "Skipping BComponent, excluded from cloudId tagging --> " + obj.toDebugString());
                        continue;
                    }
                    if (!TagUtil.hasCloudId((BIEntity)component2)) {
                        this.needsCloudIdList.add(component2);
                        continue;
                    }
                    String cloudId = BComponentIdentityWorker.getCloudOrTelemetryId(component2).orElse(CloudLinkConstants.EMPTY_CLOUD_ID).toString();
                    Object licenseFault = ccs.fw(501, component2, cloudId, null, null);
                    if (licenseFault != null) {
                        liclog.warning("Component Identity Worker License fault in execute() for component with existing cloudId: " + licenseFault);
                        licdbg.fine(() -> String.format("License count exceeded for component %s which already has a cloudId %s [CompIdWkr.doExecute()]", component2.getSlotPath(), cloudId));
                    } else {
                        licdbg.finest(() -> String.format("License check passed for component %s with existing cloudId %s", component2.getSlotPath(), cloudId));
                    }
                    this.configureAdditionalTags(component2, importMap);
                }
                ArrayList unlicensedComponents = new ArrayList();
                this.needsCloudIdList.forEach(component -> {
                    String cloudId = DiscoveryUtils.makeCloudId();
                    Object licenseFault = ccs.fw(501, component, cloudId, null, null);
                    if (licenseFault != null) {
                        unlicensedComponents.add(component.getSlotPath());
                        licdbg.fine(() -> String.format("License count exceeded for component %s; cloudId will NOT be added [CompIdWkr.doExecute()]", component.getSlotPath()));
                    } else {
                        this.newCloudId();
                        TagUtil.addCloudId((BIEntity)component, (String)cloudId);
                        licdbg.fine(() -> String.format("License check passed for component %s; adding cloudId %s", component.getSlotPath(), cloudId));
                        this.configureAdditionalTags((BComponent)component, importMap);
                    }
                });
                if (!unlicensedComponents.isEmpty()) {
                    liclog.warning(() -> String.format("Component Identity Worker License fault in execute() for %s newly identified components", unlicensedComponents.size()));
                }
            }
        }
        finally {
            this.needsCloudIdList.clear();
        }
    }

    private void configureAdditionalTags(BComponent component, Map<String, BHistoryImport> importMap) {
        String historyTag = TagUtil.getTag((BIEntity)component, (Id)BNiagaraTagDictionary.HISTORY).map(Object::toString).orElse(null);
        if (historyTag != null) {
            Optional<String> optTelemetryId = this.manager.getTelemetryId(historyTag);
            optTelemetryId.ifPresent(tid -> this.addTelemetryIdTag(component, (String)tid));
        } else if (component instanceof BHistoryImport && !component.getType().getTypeInfo().equals(CloudLinkConstants.NIAGARA_SYSTEM_HISTORY_IMPORT_TYPEINFO)) {
            BHistoryId historyId = ((BHistoryImport)component).getHistoryId();
            if (historyId.isShorthand()) {
                historyId = historyId.fromShorthand(((BHistoryImport)component).getDevice().getName());
            }
            Optional<String> optTelemetryId = this.manager.getTelemetryId(historyId);
            optTelemetryId.ifPresent(tid -> this.addTelemetryIdTag(component, (String)tid));
        } else if (component instanceof BControlPoint) {
            BControlPoint point = (BControlPoint)component;
            BAbstractProxyExt proxy = point.getProxyExt();
            if (proxy instanceof BProxyExt) {
                BProxyPointHelper.getReference((BProxyExt)((BProxyExt)proxy)).ifPresent(ref -> {
                    BHistoryImport historyImport = (BHistoryImport)importMap.get(ref);
                    if (historyImport != null) {
                        BHistoryId historyId = historyImport.getHistoryId();
                        if (historyId.isShorthand()) {
                            historyId = historyId.fromShorthand(historyImport.getDevice().getName());
                        }
                        BComponentIdentityWorker.addHistoryTag(component, historyId);
                        this.manager.getTelemetryId(historyId).ifPresent(tid -> {
                            this.addTelemetryIdTag(component, (String)tid);
                            this.addTelemetryIdTag((BComponent)historyImport, (String)tid);
                        });
                    }
                });
            }
        } else if (component instanceof BIHistorySource) {
            Optional<BHistoryId> historyId = BComponentIdentityWorker.getSourceHistoryId(component);
            historyId.ifPresent(hid -> {
                BComponentIdentityWorker.addHistoryTag(component, hid);
                this.manager.getTelemetryId((BHistoryId)hid).ifPresent(tid -> this.addTelemetryIdTag(component, (String)tid));
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, BHistoryImport> processHistoryImports() {
        HashMap<String, BHistoryImport> importMap = new HashMap<String, BHistoryImport>();
        BHistoryDatabase histDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        BComponent driversComponent = BOrd.make((String)DRIVERS_ROOT_ORD).resolve().getComponent();
        BOrd ord = BOrd.make((String)HIST_IMPORTS_QUERY);
        try (ComponentTreeCursor cursor = new ComponentTreeCursor(driversComponent, BDeviceNetwork.TYPE, null);
             HistoryDatabaseConnection histDbConn = histDb.getDbConnection(null);){
            while (cursor.next(BDeviceNetwork.class)) {
                BDevice[] devices;
                Type networkType;
                BDeviceNetwork network = (BDeviceNetwork)cursor.get();
                if (CloudLinkTagUtil.entityExcludedFromModel.test((Entity)network)) {
                    log.fine(() -> String.format("Cloud Id processing skipped; network %s is tagged as excluded", network.getName()));
                    continue;
                }
                String networkTypeName = "";
                for (networkType = network.getType(); networkType != BDeviceNetwork.TYPE && !HISTORY_ID_GENERATOR_MAP.containsKey(networkTypeName = networkType.toString()); networkType = networkType.getSuperType()) {
                }
                if (networkType == BDeviceNetwork.TYPE) {
                    log.fine(() -> String.format("Cloud Id processing skipped; network type %s is not in id generator map", network.getType().toString()));
                    continue;
                }
                for (BDevice device : devices = network.getDevices()) {
                    if (CloudLinkTagUtil.entityExcludedFromModel.test((Entity)device)) {
                        log.fine(String.format("Cloud Id processing skipped; device %s is tagged as excluded", device.getSlotPath().toString()));
                        continue;
                    }
                    BITable result = (BITable)ord.resolve((BObject)device).get();
                    try (TableCursor historyImportCursor = result.cursor();){
                        while (historyImportCursor.next()) {
                            String historyStr;
                            BHistoryImport historyImport = (BHistoryImport)historyImportCursor.get();
                            if (CloudLinkTagUtil.entityExcludedFromModel.test((Entity)historyImport)) {
                                log.fine(String.format("Cloud Id processing skipped; historyImport %s is tagged as excluded", historyImport.getSlotPath().toString()));
                                continue;
                            }
                            IGetDeviceHistoryId getId = HISTORY_ID_GENERATOR_MAP.get(networkTypeName);
                            String string = historyStr = getId != null ? getId.getId((HistorySpaceConnection)histDbConn, historyImport).orElse("") : "";
                            if (historyStr.isEmpty()) {
                                log.fine(String.format("Cloud Id processing skipped; historyImport %s historyId is empty", historyImport.getSlotPath().toString()));
                                continue;
                            }
                            Optional<BIDataValue> optTelemetryId = CloudLinkTagUtil.getTelemetryId((BComponent)historyImport);
                            Optional optCloudId = TagUtil.getCloudId((BComponent)historyImport);
                            if (optCloudId.isPresent()) {
                                Object licenseFault = this.cloudConnectionService().fw(501, historyImport, ((BIDataValue)optCloudId.get()).toString(), optTelemetryId.orElse(CloudLinkConstants.EMPTY_CLOUD_ID).toString(), null);
                                if (licenseFault != null) {
                                    liclog.warning("Component Identity Worker License fault in processHistoryImports(): " + licenseFault);
                                    BHistoryImport finalHistoryImport = historyImport;
                                    licdbg.fine(() -> String.format("License count exceeded for historyImport %s (cloudId %s); telemetryId %s will NOT be added [CompIdWkr.processHistoryImports()]", finalHistoryImport.getSlotPath(), optCloudId.orElse(null), optTelemetryId.orElse(null)));
                                    continue;
                                }
                                BHistoryImport finalHistoryImport1 = historyImport;
                                licdbg.finest(() -> String.format("License check passed for historyImport %s with existing cloudId %s and telemetryId %s", finalHistoryImport1.getSlotPath(), optCloudId.orElse(null), optTelemetryId.orElse(null)));
                            }
                            importMap.put(historyStr, historyImport);
                            String dataType = this.getDataType(historyImport, (HistorySpaceConnection)histDbConn);
                            if (dataType == null) continue;
                            TagUtil.addTag((BIEntity)historyImport, (Id)CloudLinkConstants.DATA_TYPE, (BIDataValue)BString.make((String)dataType), (int)65537);
                        }
                    }
                    finally {
                        if (NIAGARA_NETWORK_TYPE.equals(networkTypeName)) {
                            BComponentIdentityWorker.fetchRemoteTags(device);
                        }
                    }
                }
            }
        }
        return importMap;
    }

    protected void processHistories() {
        BHistoryDatabase histDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        for (BIHistory history : histDb.getHistories()) {
            if (IGNORED_HISTORY.matcher(history.getId().getHistoryName()).matches()) continue;
            BOrdList ordList = history.getConfig().getSource();
            if (!ordList.isNull()) {
                BOrd ord = ordList.get(ordList.size() - 1);
                try {
                    BObject source = ord.get();
                    if (BComponentIdentityWorker.sourceMatch(source, history.getId()) && source instanceof BIEntity && source instanceof BHistoryExt && (source = ((BHistoryExt)source).getParentPoint()) == null) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.registerHistory(history.getId(), null);
        }
    }

    protected Predicate<BComponent> makeComponentPredicate() {
        BVector includedTypesVector = this.getComponentTypes();
        BVector excludedTypesVector = this.getExcludedComponentTypes();
        if (includedTypesVector.getSlotCount() == 0 && excludedTypesVector.getSlotCount() == 0) {
            return c -> true;
        }
        List includedComponentTypes = Arrays.stream(CompUtil.getDescendants((BComponent)includedTypesVector, BTypeSpec.class)).map(BTypeSpec::getResolvedType).collect(Collectors.toList());
        List excludedComponentTypes = Arrays.stream(CompUtil.getDescendants((BComponent)excludedTypesVector, BTypeSpec.class)).map(BTypeSpec::getResolvedType).collect(Collectors.toList());
        return component -> {
            Type componentType = component.getType();
            if (!includedComponentTypes.stream().anyMatch(arg_0 -> ((Type)componentType).is(arg_0))) return false;
            if (!excludedComponentTypes.stream().noneMatch(arg_0 -> ((Type)componentType).is(arg_0))) return false;
            return true;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDataType(BHistoryImport historyImport, HistorySpaceConnection conn) {
        BIHistory history = null;
        TypeInfo recordType = null;
        Type valueType = null;
        try {
            BHistoryId historyId = historyImport.getHistoryId().fromShorthand(historyImport.getDevice().getName());
            history = conn.getHistory(historyId);
            if (history == null) {
                log.config(() -> String.format("Cannot determine data type: HistoryImport %s with historyId %s has no corresponding history in the history database", historyImport, historyId));
                String string = null;
                return string;
            }
            recordType = history.getRecordType().getTypeInfo();
            if (recordType.is(BTrendRecord.TYPE)) {
                valueType = ((BTrendRecord)recordType.getInstance().as(BTrendRecord.class)).getValueProperty().getType();
                if (valueType.is(BINumeric.TYPE)) {
                    String string = "numeric";
                    return string;
                }
                if (valueType.is(BIBoolean.TYPE)) {
                    String string = "boolean";
                    return string;
                }
                if (valueType.is(BIEnum.TYPE)) {
                    String string = "enum";
                    return string;
                }
                if (valueType.is(BString.TYPE)) {
                    String string = "string";
                    return string;
                }
            }
            String string = "other";
            return string;
        }
        catch (Exception e) {
            log.log(Level.CONFIG, String.format("Exception determining data type for history import %s:%s; historyId=%s; recordType=%s; valueType=%s", historyImport, e, historyImport.getHistoryId(), recordType, valueType), log.isLoggable(Level.FINE) ? e : null);
            String string = null;
            return string;
        }
        finally {
            if (history != null) {
                history.close();
            }
        }
    }

    protected static Optional<String> getNiagaraHistoryId(HistorySpaceConnection histDbConn, BHistoryImport histImport) {
        BHistoryId histId = histImport.getHistoryId();
        BHistoryId histLongFormId = histId.fromShorthand(histImport.getDevice().getName());
        BIHistory hist = histDbConn.getHistory(histLongFormId);
        if (hist == null) {
            histImport.doExecute();
            hist = histDbConn.getHistory(histLongFormId);
            if (hist == null) {
                if (!histId.isNull()) {
                    log.warning(() -> "A history record was not found for history import with id " + histLongFormId + "; point will not be able to map back to this history.");
                }
                return Optional.empty();
            }
        }
        return Optional.of(histLongFormId.encodeToString());
    }

    protected static Optional<String> getEbiHistoryId(HistorySpaceConnection histDbConn, BHistoryImport histImport) {
        return BComponentIdentityWorker.getEbiId((BComponent)histImport);
    }

    protected static Optional<String> getEbiId(BComponent component) {
        BValue ebiId = component.get(EBI_ID_SLOT_NAME);
        if (ebiId != null && ebiId.isSimple()) {
            try {
                return Optional.of(ebiId.asSimple().encodeToString());
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Unable to get ebi id for: " + component.getSlotPath().toDisplayString(), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        return Optional.empty();
    }

    public static boolean sourceMatch(BObject sourceObj, BHistoryId historyId) {
        Optional<BHistoryId> sourceId;
        if (sourceObj instanceof BHistoryExt) {
            BHistoryId sourceId2 = ((BHistoryExt)sourceObj).getHistoryConfig().getId();
            if (sourceId2.isShorthand()) {
                sourceId2 = sourceId2.fromShorthand(Sys.getStation().getStationName());
            }
            return historyId.equivalent((Object)sourceId2);
        }
        if (sourceObj instanceof BArchiveDescriptor) {
            BArchiveDescriptor archiveDescriptor = (BArchiveDescriptor)sourceObj;
            BHistoryId sourceId3 = archiveDescriptor.getHistoryId();
            if (sourceId3.isShorthand()) {
                sourceId3 = sourceId3.fromShorthand(archiveDescriptor.getDevice().getName());
            }
            return historyId.equivalent((Object)sourceId3);
        }
        if (sourceObj instanceof BIHistorySource && sourceObj instanceof BComponent && (sourceId = BComponentIdentityWorker.getSourceHistoryId((BComponent)sourceObj)).isPresent()) {
            return historyId.equivalent((Object)sourceId.get());
        }
        return false;
    }

    private static Optional<BHistoryId> getSourceHistoryId(BComponent source) {
        BValue config = source.get("historyConfig");
        if (config instanceof BHistoryConfig) {
            BHistoryId sourceId = ((BHistoryConfig)config).getId();
            if (BHistoryId.NULL.equivalent((Object)sourceId)) {
                return Optional.empty();
            }
            if (sourceId.isShorthand()) {
                sourceId = sourceId.fromShorthand(Sys.getStation().getStationName());
            }
            return Optional.of(sourceId);
        }
        return Optional.empty();
    }

    private static void addHistoryTag(BComponent component, BHistoryId historyId) {
        if (!TagUtil.addTag((BIEntity)component, (Id)BNiagaraTagDictionary.HISTORY, (BIDataValue)BString.make((String)historyId.encodeToString()), (int)73729)) {
            component.tags().set(BNiagaraTagDictionary.HISTORY, (BIDataValue)BString.make((String)historyId.encodeToString()));
        }
    }

    private static Optional<BIDataValue> getCloudOrTelemetryId(BComponent component) {
        if (component instanceof BHistoryImport) {
            return CloudLinkTagUtil.getTelemetryId(component);
        }
        return TagUtil.getCloudId((BComponent)component);
    }

    private void addTelemetryIdTag(BComponent component, String telemetryId) {
        TagUtil.getCloudIdString((BIObject)component).ifPresent(cid -> {
            if (telemetryId.equals(cid)) {
                this.newCloudId();
                component.tags().set(CloudLinkConstants.CLOUD_ID, (BIDataValue)BString.make((String)DiscoveryUtils.makeCloudId()));
            }
        });
        if (!TagUtil.addTag((BIEntity)component, (Id)CloudLinkConstants.TELEMETRY_ID, (BIDataValue)BString.make((String)telemetryId), (int)73729)) {
            component.tags().set(CloudLinkConstants.TELEMETRY_ID, (BIDataValue)BString.make((String)telemetryId));
        }
    }

    private static void fetchRemoteTags(BDevice device) {
        for (BProxyExt proxyExt : (BProxyExt[])CompUtil.getDescendants((BComponent)device, BProxyExt.class)) {
            if (CloudLinkTagUtil.entityExcludedFromModel.test((Entity)proxyExt)) continue;
            BProxyPointTagsHelper.fetchRemoteTags((BProxyExt)proxyExt, null);
        }
    }

    private BCloudConnectionService cloudConnectionService() {
        return (BCloudConnectionService)this.getParent().getParent();
    }

    static {
        HISTORY_ID_GENERATOR_MAP.put(NIAGARA_NETWORK_TYPE, BComponentIdentityWorker::getNiagaraHistoryId);
        HISTORY_ID_GENERATOR_MAP.put(BACNET_NETWORK_TYPE, (histDbConn, histImport) -> BHistoryImportHelper.getReference((BHistoryImport)histImport));
        HISTORY_ID_GENERATOR_MAP.put(EBI_NETWORK_TYPE, BComponentIdentityWorker::getEbiHistoryId);
        liclog = Logger.getLogger("cloudLink.license");
        licdbg = Logger.getLogger("cloudLink.license.debug");
    }
}

