/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.objectIdentity;

import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.objectIdentity.BAbstractIdentityWorker;
import com.tridium.cloudLink.objectIdentity.IIdentityManagementCallbacks;
import com.tridium.sys.station.Station;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", override=true), @NiagaraProperty(name="historyIds", type="BVector", defaultValue="new BVector()", flags=5)})
@NiagaraTopic(name="newCloudIdsAssigned")
public class BCloudIdManager
extends BAbstractDescriptor {
    @Generated
    public static final Property executionTime = BCloudIdManager.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    @Generated
    public static final Property historyIds = BCloudIdManager.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Topic newCloudIdsAssigned = BCloudIdManager.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudIdManager.class);
    private final List<IIdentityManagementCallbacks> iIdentityManagementCallbacks = new CopyOnWriteArrayList<IIdentityManagementCallbacks>();
    private ScheduledExecutorService worker;
    private boolean newCloudIds;
    private static final Logger log = Logger.getLogger("cloudLink.identity.management");
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");

    @Generated
    public BVector getHistoryIds() {
        return (BVector)this.get(historyIds);
    }

    @Generated
    public void setHistoryIds(BVector v) {
        this.set(historyIds, (BValue)v, null);
    }

    @Generated
    public void fireNewCloudIdsAssigned(BValue event) {
        this.fire(newCloudIdsAssigned, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 23: {
                this.fwStationStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BCloudConnectionService ccs = (BCloudConnectionService)this.getParent();
        if (ccs == null || ccs.isFatalFault()) {
            return;
        }
        this.worker = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("cloudLink.cloudIdManager");
                t.setPriority(1);
                return t;
            }
        });
    }

    private void fwStationStarted() {
        if (!BAbsTime.DEFAULT.equals((Object)this.getLastSuccess())) {
            this.execute();
        }
    }

    protected void fwStopped() {
        if (this.worker != null) {
            this.worker.shutdownNow();
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("CloudIdManager.icon"));
    }

    public IFuture postExecute(Action action, BValue argument, Context cx) {
        if (execute.equals(action)) {
            if (this.worker != null) {
                this.worker.execute(this::doExecute);
            }
            return null;
        }
        return this.post(action, argument, cx);
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudConnectionService;
    }

    public void doExecute() {
        if (!this.isRunning()) {
            this.setState(BDescriptorState.idle);
            return;
        }
        this.executeInProgress();
        this.newCloudIds = false;
        try {
            for (BAbstractIdentityWorker idWorker : (BAbstractIdentityWorker[])this.getChildren(BAbstractIdentityWorker.class)) {
                idWorker.execute();
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error adding cloudIds: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            this.checkNewIds();
            this.executeFail(ex);
            throw ex;
        }
        this.checkNewIds();
        this.executeOk();
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BComplex parent = this.getParent();
        BCloudConnectionService ccs = null;
        if (parent instanceof BCloudConnectionService) {
            ccs = (BCloudConnectionService)parent;
        }
        newStatus = !this.getEnabled() || ccs != null && ccs.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public void registerCallbacks(IIdentityManagementCallbacks callback) {
        this.iIdentityManagementCallbacks.add(callback);
    }

    public Optional<String> getTelemetryId(String historyId) {
        return this.getTelemetryId(BHistoryId.make((String)historyId));
    }

    public Optional<String> getTelemetryId(BHistoryId historyId) {
        BVector devices = this.getHistoryIds();
        BValue deviceValue = devices.get(SlotPath.escape((String)historyId.getDeviceName()));
        if (!(deviceValue instanceof BVector)) {
            return Optional.empty();
        }
        BValue cloudId = ((BComplex)deviceValue).get(SlotPath.escape((String)historyId.getHistoryName()));
        return cloudId != null ? Optional.of(cloudId.toString()) : Optional.empty();
    }

    boolean registerHistory(BHistoryId historyId, String telemetryId) {
        String historyName;
        BVector histories = this.getDeviceHistories(historyId);
        if (histories.get(historyName = SlotPath.escape((String)historyId.getHistoryName())) == null) {
            this.workerNewCloudIdCreated();
            histories.add(historyName, (BValue)BString.make((String)(telemetryId != null ? telemetryId : DiscoveryUtils.makeCloudId())), 1);
            return true;
        }
        return false;
    }

    void setTelemetryId(String historyId, String telemetryId) {
        String historyName;
        BHistoryId id = BHistoryId.make((String)historyId);
        BVector histories = this.getDeviceHistories(id);
        if (histories.get(historyName = SlotPath.escape((String)id.getHistoryName())) != null) {
            histories.set(historyName, (BValue)BString.make((String)telemetryId));
        } else {
            histories.add(historyName, (BValue)BString.make((String)telemetryId), 1);
        }
    }

    void workerNewCloudIdCreated() {
        if (!this.newCloudIds) {
            this.newCloudIds = true;
            for (IIdentityManagementCallbacks callback : this.iIdentityManagementCallbacks) {
                callback.beginNewIds();
            }
        }
    }

    private BVector getDeviceHistories(BHistoryId id) {
        String deviceName;
        BVector devices = this.getHistoryIds();
        BValue deviceValue = devices.get(deviceName = SlotPath.escape((String)id.getDeviceName()));
        if (deviceValue == null) {
            deviceValue = new BVector();
            devices.add(deviceName, deviceValue);
        } else if (!(deviceValue instanceof BVector)) {
            deviceValue = new BVector();
            devices.set(deviceName, deviceValue);
        }
        return (BVector)deviceValue;
    }

    private void checkNewIds() {
        if (this.newCloudIds) {
            try {
                Station.saveSync();
                this.newCloudIds = false;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "error saving station after adding cloudIds", log.isLoggable(Level.FINE) ? ex : null);
            }
            this.fireNewCloudIdsAssigned((BValue)BBoolean.DEFAULT);
        }
    }
}

