/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.msg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public interface GetHistoriesResult {
    public static final String HISTORY_QUERY_RESULT_COUNT_FACET_KEY = "historyQueryResultCount";

    public HistoriesResultPage page();

    public HistoriesResultLinks links();

    public Map<String, Map<BHistoryId, RecordsWithContext>> getHistoriesMap();

    public static Context makeHistoryQueryResultCountContext(Context cx, int resultCount) {
        BFacets facets = BFacets.make((String)HISTORY_QUERY_RESULT_COUNT_FACET_KEY, (int)resultCount);
        return cx == null ? facets : new BasicContext(cx, facets);
    }

    public static OptionalInt extractHistoryQueryResultCount(Context cx) {
        BObject value;
        if (cx != null && (value = cx.getFacet(HISTORY_QUERY_RESULT_COUNT_FACET_KEY)) instanceof BInteger) {
            return OptionalInt.of(((BInteger)value).getInt());
        }
        return OptionalInt.empty();
    }

    public static class RecordsWithContext {
        private final List<BHistoryRecord> records;
        private final Context context;

        public RecordsWithContext(List<BHistoryRecord> records, Context context) {
            this.records = Collections.unmodifiableList(new LinkedList<BHistoryRecord>(records));
            this.context = new BasicContext(context);
        }

        public List<BHistoryRecord> getRecords() {
            return this.records;
        }

        public Context getContext() {
            return this.context;
        }
    }

    public static interface HistoriesResultLinks {
        public String getFirst();

        public String getSelf();

        public String getNext();

        public String getLast();
    }

    public static interface HistoriesResultPage {
        public int getPageSize();

        public int getTotalElements();

        public int getPageCount();

        public int getPageNumber();
    }
}

