/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.model;

import com.tridium.clUtils.BModelDiscoveryService;
import com.tridium.clUtils.DiscoveryUtils;
import com.tridium.clUtils.util.CloudIdConstants;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.model.BModelExportPolicy;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Relation;

@NiagaraType
public class BModelDiscoveryExportPolicy
extends BModelExportPolicy {
    @Generated
    public static final Type TYPE = Sys.loadType(BModelDiscoveryExportPolicy.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.model.exportPolicy");
    private BModelDiscoveryService modelDiscoveryService;
    private ZipFile zipFile;
    private Enumeration<? extends ZipEntry> modelResults;
    private List<String> networkIds;
    private boolean returnedService;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        try {
            Sys.findService((Type)BModelDiscoveryService.TYPE).ifPresent(biService -> this.linkTo("modelExportLink", (BComponent)biService, (Slot)BModelDiscoveryService.modelDiscoveryComplete, (Slot)BAbstractDescriptor.execute));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Cannot link model discovery completion to model export execution: %s", ex), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    @Override
    public Predicate<BComponent> getComponentTypeIncludedInModel() {
        return c -> true;
    }

    @Override
    public Predicate<Relation> getRelationTypeIncludeInModel() {
        return r -> true;
    }

    @Override
    protected void initialize() {
        try {
            this.modelDiscoveryService = (BModelDiscoveryService)Sys.findService((Type)BModelDiscoveryService.TYPE).orElseThrow(() -> new IllegalStateException("No Model Discovery Service found in station"));
            BOrd fileOrd = this.modelDiscoveryService.getModelFile();
            BIFile modelFile = BFileSystem.INSTANCE.makeFile((FilePath)fileOrd.parse()[0]);
            this.zipFile = new ZipFile(((BLocalFileStore)modelFile.getStore()).getLocalFile());
            this.networkIds = new ArrayList<String>();
            this.returnedService = false;
            this.modelResults = this.zipFile.entries();
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("clUtils", "modelDiscovery.exportPolicy.initializeError", new Object[]{e.toString()}, (Throwable)e);
        }
    }

    @Override
    protected void cleanup() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("clUtils", "modelDiscovery.exportPolicy.cleanupError", new Object[]{e.toString()}, (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.modelResults == null) {
            return false;
        }
        if (this.modelResults.hasMoreElements()) {
            return true;
        }
        return !this.returnedService;
    }

    @Override
    public Object next() {
        if (this.modelResults == null) {
            return null;
        }
        try {
            if (this.modelResults.hasMoreElements()) {
                ZipEntry ze = this.modelResults.nextElement();
                InputStream is = this.zipFile.getInputStream(ze);
                JSONObject o = DiscoveryUtils.readJSONObject((InputStream)is);
                if (ze.getName().endsWith("networkInfo.json")) {
                    this.networkIds.add(o.optString("cloudId", null));
                }
                return o;
            }
            if (!this.returnedService) {
                JSONObject o = new JSONObject();
                BCloudConnectionService svc = this.getPolicyContainer().getChannel().getConnectionService().orElse(null);
                o.put("name", (Object)(svc != null ? svc.getDisplayName(null) : "null"));
                if (svc != null) {
                    TagUtil.getOrAddCloudId((BIEntity)svc, (Function)CloudIdConstants.CLOUD_ID_FUNCTION);
                }
                JSONArray networks = new JSONArray();
                this.networkIds.forEach(s -> networks.put(s));
                o.put("networks", (Object)networks);
                this.returnedService = true;
                return o;
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("modelDiscovery", "modelDiscovery.exportPolicy.nextError", new Object[]{e.toString()}, (Throwable)e);
        }
        return null;
    }
}

