/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.model;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BModelChannel;
import com.tridium.cloudLink.model.BModelExportPolicy;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.cloudLink.objectIdentity.BComponentIdentityWorker;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryResult;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;

@NiagaraType
@NiagaraProperty(name="scope", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")", flags=5)
public class BCloudIdExportPolicy
extends BModelExportPolicy {
    @Generated
    public static final Property scope = BCloudIdExportPolicy.newProperty((int)5, (BValue)BOrd.make((String)"station:|slot:/"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudIdExportPolicy.class);
    protected Cursor<BIEntity> cursor;
    protected boolean cursorDone;
    Iterator<BIHistory> historyIterator;
    protected boolean hasNext;
    protected BIEntity next;
    protected BCloudIdManager manager;

    @Generated
    public BOrd getScope() {
        return (BOrd)this.get(scope);
    }

    @Generated
    public void setScope(BOrd v) {
        this.set(scope, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void initialize() {
        BOrd queryOrd = BOrd.make((String)"neql:nc:cloudId and not nc:excluded");
        BQueryResult result = (BQueryResult)queryOrd.get(this.getScope().get((BObject)Sys.getStation()));
        this.cursor = result.cursor();
        this.cursorDone = false;
        BHistoryDatabase histDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        this.historyIterator = Arrays.stream(histDb.getHistories()).iterator();
        BModelChannel channel = this.getChannel();
        if (channel != null) {
            this.manager = channel.getConnectionService().map(BCloudConnectionService::getCloudIdManager).orElse(null);
        }
    }

    @Override
    protected void cleanup() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        this.hasNext = false;
    }

    @Override
    public Predicate<BComponent> getComponentTypeIncludedInModel() {
        return component -> TagUtil.getCloudId((BComponent)component).isPresent();
    }

    @Override
    public Predicate<Relation> getRelationTypeIncludeInModel() {
        return relation -> relation.getEndpoint().tags().contains(CloudLinkConstants.CLOUD_ID);
    }

    @Override
    public boolean hasNext() {
        block5: {
            this.hasNext = false;
            if (!this.cursorDone) {
                try {
                    if (this.cursor.next()) {
                        BIEntity nextEntity = (BIEntity)this.cursor.get();
                        this.hasNext = true;
                        this.next = nextEntity;
                        break block5;
                    }
                    this.cursorDone = true;
                    this.hasNextHistory();
                }
                catch (CursorException e) {
                    this.cursorDone = true;
                    this.hasNextHistory();
                }
            } else {
                this.hasNextHistory();
            }
        }
        return this.hasNext;
    }

    @Override
    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more elements are available or you did not first call hasNext().");
        }
        return this.next;
    }

    private void hasNextHistory() {
        if (this.manager == null) {
            return;
        }
        while (this.historyIterator.hasNext()) {
            BIHistory nextHistory = this.historyIterator.next();
            if (!this.manager.getTelemetryId(nextHistory.getId()).isPresent()) continue;
            BOrdList ordList = nextHistory.getConfig().getSource();
            if (!ordList.isNull()) {
                BOrd source = ordList.get(ordList.size() - 1);
                try {
                    BObject sourceObj = source.get();
                    if (BComponentIdentityWorker.sourceMatch(sourceObj, nextHistory.getId()) && sourceObj instanceof BIEntity && CloudLinkTagUtil.entityExcludedFromModel.test((Entity)((BIEntity)sourceObj))) {
                        continue;
                    }
                }
                catch (InvalidOrdBaseException | NullOrdException | SyntaxException | UnknownSchemeException | UnresolvedException throwable) {
                    // empty catch block
                }
            }
            this.hasNext = true;
            this.next = nextHistory.getConfig();
            break;
        }
    }
}

