/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.msg.HistoryItem;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;

public interface HistoryRecordEncoder {
    public static final Logger log = Logger.getLogger("cloudLink.channel.history");
    public static final BFacets RECORD_VALUE_FACETS = BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);

    public JSONObject encode(HistoryItem var1);

    public static String getRecordValue(BHistoryRecord record) {
        SlotCursor c = record.getProperties();
        JSONObject rv = new JSONObject();
        while (c.next()) {
            if (c.get().isSimple()) {
                try {
                    rv.put(c.property().getName(), (Object)c.get().asSimple().encodeToString());
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, String.format("Could not encode property %s, value %s to HistoryItem", c.property().getName(), c.get()), log.isLoggable(Level.FINE) ? ioe : null);
                }
                continue;
            }
            log.warning(() -> String.format("Encoding non-BSimple into history record: prop=%s, val=%s; may not decode correctly!", c.property().getName(), c.get()));
            rv.put(c.property().getName(), (Object)c.get().toString((Context)RECORD_VALUE_FACETS));
        }
        return rv.toString();
    }

    public static String getValue(BHistoryRecord record) {
        if (record instanceof BTrendRecord) {
            return Objects.toString(record.get(((BTrendRecord)record).getValueProperty()), "");
        }
        return Objects.toString(record.get("value"), record.toString());
    }
}

