/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.util.ICloudLinkBatchContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;

public class HistoryBatchIterator<T>
implements Iterator<T> {
    private final Iterator<HistoryItemWrapper> iterator;
    private final ICloudLinkBatchContainer<T, HistoryItemWrapper> batch;
    private boolean abort;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public HistoryBatchIterator(Iterator<HistoryItemWrapper> iterator, ICloudLinkBatchContainer<T, HistoryItemWrapper> batch) {
        Objects.requireNonNull(iterator, "HistoryItem iterator cannot be null");
        Objects.requireNonNull(batch, "batch container cannot be null");
        this.iterator = iterator;
        this.batch = batch;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() && !this.abort;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more items are available");
        }
        do {
            this.batch.add(this.iterator.next());
            if (!this.batch.isFull()) continue;
            log.finer("batch is filled");
            break;
        } while (this.hasNext());
        return this.batch.get();
    }

    public void abort() {
        this.abort = true;
    }
}

