/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.channel.BHistoriesChannel;
import com.tridium.cloudLink.history.BCloudHistoryAutoExportConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfig;
import com.tridium.cloudLink.util.BCloudPolicyContainer;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxConcurrentExportExecutions", type="int", defaultValue="10", flags=7, facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")}), @NiagaraProperty(name="maxConcurrentExecutions", type="int", defaultValue="4", facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")}, override=true), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15)))"), @NiagaraProperty(name="autoExport", type="BCloudHistoryAutoExportConfig", defaultValue="new BCloudHistoryAutoExportConfig()")})
@NiagaraActions(value={@NiagaraAction(name="executeAll"), @NiagaraAction(name="retryFailedExports")})
public final class BCloudHistoryExportConfigContainer
extends BCloudPolicyContainer {
    private static final int MIN_THREAD_POOL_SIZE = 2;
    @Generated
    public static final Property maxConcurrentExportExecutions = BCloudHistoryExportConfigContainer.newProperty((int)7, (int)10, (BFacets)BFacets.make((String)"min", (int)2));
    @Generated
    public static final Property maxConcurrentExecutions = BCloudHistoryExportConfigContainer.newProperty((int)0, (int)4, (BFacets)BFacets.make((String)"min", (int)2));
    @Generated
    public static final Property retryTrigger = BCloudHistoryExportConfigContainer.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    @Generated
    public static final Property autoExport = BCloudHistoryExportConfigContainer.newProperty((int)0, (BValue)new BCloudHistoryAutoExportConfig(), null);
    @Generated
    public static final Action executeAll = BCloudHistoryExportConfigContainer.newAction((int)0, null);
    @Generated
    public static final Action retryFailedExports = BCloudHistoryExportConfigContainer.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudHistoryExportConfigContainer.class);
    static final Logger LOGGER = Logger.getLogger("cloudLink.channel.history");

    @Generated
    public int getMaxConcurrentExportExecutions() {
        return this.getInt(maxConcurrentExportExecutions);
    }

    @Generated
    public void setMaxConcurrentExportExecutions(int v) {
        this.setInt(maxConcurrentExportExecutions, v, null);
    }

    @Generated
    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    @Generated
    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    @Generated
    public BCloudHistoryAutoExportConfig getAutoExport() {
        return (BCloudHistoryAutoExportConfig)this.get(autoExport);
    }

    @Generated
    public void setAutoExport(BCloudHistoryAutoExportConfig v) {
        this.set(autoExport, (BValue)v, null);
    }

    @Generated
    public void executeAll() {
        this.invoke(executeAll, null, null);
    }

    @Generated
    public void retryFailedExports() {
        this.invoke(retryFailedExports, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected Type getChannelType() {
        return BHistoriesChannel.TYPE;
    }

    @Override
    protected Type[] getPolicyTypes() {
        return new Type[]{BCloudHistoryExportConfig.TYPE};
    }

    @Override
    protected String getWorkerThreadName() {
        return "NcsHistoryExportWorker";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected int getMinThreadPoolSize() {
        return 2;
    }

    @Override
    public void started() throws Exception {
        super.started();
        BTimeTrigger t = this.getRetryTrigger();
        this.linkTo("retryLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)retryFailedExports);
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
    }

    public Optional<BHistoriesChannel> getHistoriesChannel() {
        BComplex channel = this.getParent();
        if (channel != null && channel instanceof BHistoriesChannel) {
            return Optional.of((BHistoriesChannel)channel);
        }
        return Optional.empty();
    }

    Queue getAsyncWorkQueue() {
        return this.asyncWorkQueue;
    }

    public void doExecuteAll() {
        BCloudHistoryExportConfig[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])this.getChildren(BCloudHistoryExportConfig.class)) {
            if (!config.getEnabled()) continue;
            config.execute();
        }
    }

    public void doRetryFailedExports() {
        BCloudHistoryExportConfig[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])this.getChildren(BCloudHistoryExportConfig.class)) {
            if (config.isUnoperational() || !config.isFault() || !config.retryReady()) continue;
            config.execute();
        }
    }
}

