/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.channel.BHistoriesChannel;
import com.tridium.cloudLink.history.BHistoryArchiveCache;
import com.tridium.cloudLink.history.HistoryArchiveCacheEntry;
import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.cloudLink.util.MergedListsView;
import com.tridium.collection.BListTable;
import com.tridium.util.EscUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.history.db.BArchiveHistoryProvider;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxArchiveResultsPerQuery", type="int", defaultValue="5000", facets={@Facet(name="BFacets.MIN", value="1")}, override=true), @NiagaraProperty(name="cloudConnectionService", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="historyArchiveCache", type="BHistoryArchiveCache", defaultValue="new BHistoryArchiveCache()")})
public class BCloudArchiveHistoryProvider
extends BArchiveHistoryProvider {
    @Generated
    public static final Property maxArchiveResultsPerQuery = BCloudArchiveHistoryProvider.newProperty((int)0, (int)5000, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property cloudConnectionService = BCloudArchiveHistoryProvider.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property historyArchiveCache = BCloudArchiveHistoryProvider.newProperty((int)0, (BValue)new BHistoryArchiveCache(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudArchiveHistoryProvider.class);
    private BCloudConnectionService resolvedCcs;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private static final Lexicon lexicon = Lexicon.make(BCloudArchiveHistoryProvider.class);

    @Generated
    public BOrd getCloudConnectionService() {
        return (BOrd)this.get(cloudConnectionService);
    }

    @Generated
    public void setCloudConnectionService(BOrd v) {
        this.set(cloudConnectionService, (BValue)v, null);
    }

    @Generated
    public BHistoryArchiveCache getHistoryArchiveCache() {
        return (BHistoryArchiveCache)this.get(historyArchiveCache);
    }

    @Generated
    public void setHistoryArchiveCache(BHistoryArchiveCache v) {
        this.set(historyArchiveCache, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isLikelyToContainArchivedHistory(BHistoryConfig historyConfig, Context context) {
        this.checkCloudConnectionService();
        if (!this.isOperational()) {
            return false;
        }
        BHistoriesChannel historiesChannel = (BHistoriesChannel)this.resolvedCcs.getChannel("History");
        if (historiesChannel == null || !historiesChannel.isOperational()) {
            log.warning("Histories channel is not operational");
            return false;
        }
        String historyId = EscUtil.slot.escape(historyConfig.getId().encodeToString());
        return historiesChannel.getLastRecordSentTimes().getSlot(historyId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<Cursor<BHistoryRecord>> doTimeQuery(BHistoryConfig historyConfig, BAbsTime startTime, BAbsTime endTime, boolean descending, int limit, Context context) {
        log.finest(() -> String.format("Querying cloud archive history provider with parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", historyConfig.getId().toString(), startTime.encodeToString(), endTime.encodeToString(), descending, limit));
        BHistoryArchiveCache cache = this.getHistoryArchiveCache();
        Object object = cache.getSyncObject();
        synchronized (object) {
            Optional<HistoryArchiveCacheEntry> maybePartialEntry;
            if (cache.hasEntry(historyConfig.getId(), startTime, endTime, descending, limit)) {
                return cache.getEntry(historyConfig.getId(), startTime, endTime, descending, limit).map(entry -> entry.getCursor());
            }
            if (cache.hasPartialEntry(historyConfig.getId(), startTime, endTime, descending) && (maybePartialEntry = cache.getEntry(historyConfig.getId(), startTime, endTime, descending, limit)).isPresent()) {
                int numCachedRecords;
                HistoryArchiveCacheEntry partialEntry = maybePartialEntry.get();
                List<BHistoryRecord> cachedRecords = partialEntry.getRecords();
                BAbsTime lastCachedTime = cachedRecords.get(cachedRecords.size() - 1).getTimestamp();
                BAbsTime newStartTime = lastCachedTime.add(BRelTime.make((long)1L));
                Optional<GetHistoriesResult.RecordsWithContext> maybeCloudData = this.queryCloudDataStore(historyConfig, newStartTime, endTime, descending, limit - (numCachedRecords = partialEntry.getRecordCount()), context);
                if (!maybeCloudData.isPresent()) {
                    return Optional.of(partialEntry.getCursor());
                }
                GetHistoriesResult.RecordsWithContext cloudData = maybeCloudData.get();
                Context mergedContext = partialEntry.getCursor().getContext();
                try {
                    BHistoryRecord preRecord = HistoryCursor.extractPreRecord((BFacets)mergedContext.getFacets());
                    BHistoryRecord postRecord = HistoryCursor.extractPostRecord((BFacets)cloudData.getContext().getFacets());
                    mergedContext = new BasicContext(mergedContext, HistoryCursor.makeBoundaryRecordFacets((BHistoryRecord)preRecord, (BHistoryRecord)postRecord));
                }
                catch (IOException e) {
                    mergedContext = new BasicContext(mergedContext, BFacets.NULL);
                }
                mergedContext = GetHistoriesResult.makeHistoryQueryResultCountContext(mergedContext, cachedRecords.size() + cloudData.getRecords().size());
                MergedListsView<BHistoryRecord> mergedRecords = new MergedListsView<BHistoryRecord>(cachedRecords, mergedContext);
                mergedRecords.addList(cloudData.getRecords());
                cache.addEntry(historyConfig.getId(), startTime, endTime, descending, limit, mergedRecords);
                return Optional.of(mergedRecords.getCursor());
            }
            log.finest(() -> String.format("Cloud archive history provider found no entry in cache with parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", historyConfig.getId().toString(), startTime.encodeToString(), endTime.encodeToString(), descending, limit));
            Optional<GetHistoriesResult.RecordsWithContext> maybeCloudData = this.queryCloudDataStore(historyConfig, startTime, endTime, descending, limit, context);
            if (!maybeCloudData.isPresent()) {
                return Optional.empty();
            }
            GetHistoriesResult.RecordsWithContext cloudData = maybeCloudData.get();
            cache.addEntry(historyConfig.getId(), startTime, endTime, descending, limit, new MergedListsView<BHistoryRecord>(cloudData.getRecords(), cloudData.getContext()));
            return Optional.of(new BListTable(cloudData.getRecords(), cloudData.getContext()).cursor());
        }
    }

    protected Optional<GetHistoriesResult.RecordsWithContext> queryCloudDataStore(BHistoryConfig historyConfig, BAbsTime startTime, BAbsTime endTime, boolean descending, int limit, Context context) {
        this.checkCloudConnectionService();
        if (!this.isOperational()) {
            return Optional.empty();
        }
        BHistoriesChannel historiesChannel = (BHistoriesChannel)this.resolvedCcs.getChannel("History");
        if (historiesChannel == null || !historiesChannel.isOperational()) {
            log.warning("Histories channel is not operational");
            return Optional.empty();
        }
        BValue time = historiesChannel.getLastRecordSentTimes().get(EscUtil.slot.escape(historyConfig.getId().encodeToString()));
        if (time == null || time.as(BAbsTime.class) == BAbsTime.NULL) {
            log.finest(() -> String.format("Skipping cloud data store query for id %s as it has never been sent to cloud data store", historyConfig.getId()));
            return Optional.empty();
        }
        log.finest(() -> String.format("Cloud archive history provider querying cloud date store with parameters (id=%s, start=%s, end=%s, descending=%b, limit=%d)", historyConfig.getId().toString(), startTime.encodeToString(), endTime.encodeToString(), descending, limit));
        GetHistoriesResult.RecordsWithContext histories = historiesChannel.getHistories(historyConfig.getId(), startTime, endTime, descending, limit, false, false);
        return Optional.ofNullable(histories);
    }

    public void started() {
        BOrd ccsOrd = this.getCloudConnectionService();
        if (ccsOrd == BOrd.NULL) {
            List<BOrd> ccsOrds = CloudLinkUtils.findCloudConnectionServiceOrds();
            if (ccsOrds.size() == 1) {
                this.setCloudConnectionService(ccsOrds.get(0));
                this.checkCloudConnectionService();
            } else if (ccsOrds.size() > 1) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(lexicon.getText("noUniqueCloudConnectionService"));
            } else {
                this.setStatus(BStatus.fault);
                this.setFaultCause(lexicon.getText("noCloudConnectionService"));
            }
        } else {
            this.checkCloudConnectionService();
        }
    }

    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(cloudConnectionService)) {
            this.checkCloudConnectionService();
        }
    }

    public void checkCloudConnectionService() {
        BOrd ccsOrd = this.getCloudConnectionService();
        if (ccsOrd == BOrd.NULL) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(lexicon.getText("noCloudConnectionService"));
            return;
        }
        try {
            this.resolvedCcs = (BCloudConnectionService)ccsOrd.resolve((BObject)this).get();
            if (!this.resolvedCcs.isOperational()) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(lexicon.getText("cloudConnectionServiceFault"));
            } else {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            }
        }
        catch (Exception e) {
            log.warning(() -> String.format("Cannot resolve Cloud Connection Service configuration: %s", e.getMessage()));
            this.setStatus(BStatus.fault);
            this.setFaultCause(lexicon.getText("noUniqueCloudConnectionService"));
        }
    }
}

