/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.heartbeat;

import com.tridium.cloudLink.channel.BHeartbeatChannel;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicyContainer;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IConnectionCallback;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
public abstract class BHeartbeatPolicy
extends BAbstractDescriptor
implements IConnectionCallback {
    @Generated
    public static final Type TYPE = Sys.loadType(BHeartbeatPolicy.class);
    private static final long FOUR_MINUTES_IN_SECONDS = 240L;
    private BHeartbeatPolicyContainer container;
    protected int timeoutCount;
    protected int reconnectCount;
    protected long reconnectTime;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BAbstractTransport transport = this.getContainer().getChannel().getChannelConfig().getTransport(this.getOperationId());
        if (transport instanceof BAbstractConnectedTransport) {
            this.getExecutionTime().setNextTrigger(BAbsTime.END_OF_TIME);
            ((BAbstractConnectedTransport)transport).addConnectionCallback(this);
        }
    }

    private void fwStopped() {
        this.container = null;
    }

    @Override
    public void onConnect() {
        if (Sys.atSteadyState()) {
            this.getExecutionTime().checkTime();
        }
    }

    @Override
    public void onDisconnect() {
    }

    public void doExecute() {
        CompletableFuture<SendHeartbeatResult> future = null;
        long timeout = this.getTimeoutSec();
        try {
            future = this.getContainer().getChannel().heartbeat(this);
            SendHeartbeatResult result = future.get(timeout, TimeUnit.SECONDS);
            if (result.isSuccess()) {
                this.handleResults(result);
                this.executeOk();
            } else {
                this.executeFail("Device Heartbeat task failed");
            }
        }
        catch (ExecutionException exExcept) {
            Throwable cause = exExcept.getCause();
            this.getLogger().log(Level.INFO, "Device Heartbeat send task failed with exception ", this.getLogger().isLoggable(Level.FINE) ? cause : null);
            this.executeFail(exExcept.getMessage());
        }
        catch (InterruptedException interExcept) {
            this.getLogger().warning("Device Heartbeat send task was interrupted");
            this.executeFail("Device Heartbeat send task was interrupted");
        }
        catch (TimeoutException ex) {
            BAbstractTransport transport;
            this.getLogger().warning(() -> String.format("Device Heartbeat send task timed out, no response after %s seconds", timeout));
            future.cancel(true);
            BHeartbeatChannel channel = this.getContainer().getChannel();
            if (++this.timeoutCount > channel.getTimeoutThreshold() && (transport = channel.getChannelConfig().getTransport(ISendHeartbeatHandler.getOperationId())) instanceof BAbstractConnectedTransport) {
                this.getLogger().fine("exceeded threshold for heartbeat timeouts, reconnecting.");
                ((BAbstractConnectedTransport)transport).reconnect();
                this.timeoutCount = 0;
                ++this.reconnectCount;
                this.reconnectTime = BAbsTime.now().getMillis();
            }
            this.executeFail("Device Heartbeat send task timed out");
        }
        catch (Exception except) {
            this.getLogger().warning(() -> String.format("Device Heartbeat send task failed: %s", except));
            this.executeFail(except.getMessage());
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        ((BHeartbeatPolicyContainer)this.getParent().as(BHeartbeatPolicyContainer.class)).getAsyncWorkQueue().enqueue((Object)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void updateStatus() {
        if (!this.isRunning()) {
            return;
        }
        int newStatus = this.getStatus().getBits();
        BHeartbeatChannel channel = this.getContainer().getChannel();
        newStatus = !this.getEnabled() || channel != null && channel.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = channel == null || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public void executeOk() {
        this.timeoutCount = 0;
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public final void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public abstract Map<String, Object> getPayloadProperties();

    protected abstract Logger getLogger();

    public String getOperationId() {
        return ISendHeartbeatHandler.getOperationId();
    }

    public void handleResults(SendHeartbeatResult result) {
    }

    public final BHeartbeatPolicyContainer getContainer() {
        if (this.container == null) {
            this.container = (BHeartbeatPolicyContainer)this.getParent();
        }
        if (this.container == null) {
            throw new IllegalStateException("getContainer() called on unmounted policy object");
        }
        return this.container;
    }

    protected long getTimeoutSec() {
        if (this.getExecutionTime().getNextTrigger().equals((Object)BAbsTime.END_OF_TIME)) {
            return 240L;
        }
        return (this.getExecutionTime().getNextTrigger().getMillis() - BAbsTime.now().getMillis()) / 4000L * 3L;
    }
}

