/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.file;

import com.tridium.cloudLink.transport.IMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class FileUploadRequest
implements IMessage {
    private final String name;
    private final Consumer<OutputStream> fileData;
    private final Map<String, Object> metadata;
    private static final int FILE_READ_BUFFER_SIZE = 8192;

    public FileUploadRequest(String fileName, Map<String, String> metadata) {
        this(fileName, FileUploadRequest.fileToOutputStreamFunc(fileName), metadata);
    }

    public FileUploadRequest(String remoteName, Consumer<OutputStream> fileData, Map<String, String> metadata) {
        this.name = remoteName;
        this.fileData = fileData;
        this.metadata = metadata != null ? new HashMap<String, String>(metadata) : Collections.emptyMap();
    }

    public String getFileName() {
        return this.name;
    }

    public void upload(OutputStream outStream) {
        this.fileData.accept(outStream);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public byte[] getPayload() {
        throw new UnsupportedOperationException("Method not available for files");
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    protected static Consumer<OutputStream> fileToOutputStreamFunc(String fileName) {
        return outStream -> {
            try (FileInputStream inStream = new FileInputStream(fileName);){
                int length;
                byte[] buf = new byte[8192];
                while ((length = inStream.read(buf)) != -1) {
                    outStream.write(buf, 0, length);
                }
                outStream.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }
}

