/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.event;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BEventsChannel;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.event.BEventRecipient;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cloudConnectionService", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="enableBatchEvents", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(cloudLink:events.batch.enabled)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(cloudLink:events.batch.disabled)%\"")}), @NiagaraProperty(name="eventBatchDelay", type="BRelTime", defaultValue="BRelTime.make(30000)"), @NiagaraProperty(name="eventBatchSize", type="int", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="2"), @Facet(name="BFacets.MAX", value="512")}), @NiagaraProperty(name="sendFailWarnInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)", flags=5), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=257)})
@NiagaraAction(name="sendBatchEvents", flags=4)
public class BCloudLinkEventRecipient
extends BEventRecipient {
    @Generated
    public static final Property cloudConnectionService = BCloudLinkEventRecipient.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    @Generated
    public static final Property enableBatchEvents = BCloudLinkEventRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(cloudLink:events.batch.enabled)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(cloudLink:events.batch.disabled)%")));
    @Generated
    public static final Property eventBatchDelay = BCloudLinkEventRecipient.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    @Generated
    public static final Property eventBatchSize = BCloudLinkEventRecipient.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)2), (BFacets)BFacets.make((String)"max", (int)512)));
    @Generated
    public static final Property sendFailWarnInterval = BCloudLinkEventRecipient.newProperty((int)5, (BValue)BRelTime.makeHours((int)1), null);
    @Generated
    public static final Property lastSentToCloud = BCloudLinkEventRecipient.newProperty((int)257, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Action sendBatchEvents = BCloudLinkEventRecipient.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudLinkEventRecipient.class);
    private BCloudConnectionService connectionService;
    private BEventsChannel eventsChannel;
    private int pendingEventCount;
    private BEvent[] pendingEvents;
    private Clock.Ticket eventSendTicket;
    private boolean eventSendFailLogFlag;
    private static final ReentrantLock eventBatchLock = new ReentrantLock();
    private static final BIcon icon = BIcon.make((BIcon)BIcon.make((String)"module://event/icons/eventService.png"), (BIcon)BIcon.make((String)"module://event/icons/eventBadge.png"));
    private static final Logger log = Logger.getLogger("cloudLink.channel.event");
    private static final Lexicon lexicon = Lexicon.make(BCloudLinkEventRecipient.class);

    @Generated
    public BOrd getCloudConnectionService() {
        return (BOrd)this.get(cloudConnectionService);
    }

    @Generated
    public void setCloudConnectionService(BOrd v) {
        this.set(cloudConnectionService, (BValue)v, null);
    }

    @Generated
    public boolean getEnableBatchEvents() {
        return this.getBoolean(enableBatchEvents);
    }

    @Generated
    public void setEnableBatchEvents(boolean v) {
        this.setBoolean(enableBatchEvents, v, null);
    }

    @Generated
    public BRelTime getEventBatchDelay() {
        return (BRelTime)this.get(eventBatchDelay);
    }

    @Generated
    public void setEventBatchDelay(BRelTime v) {
        this.set(eventBatchDelay, (BValue)v, null);
    }

    @Generated
    public int getEventBatchSize() {
        return this.getInt(eventBatchSize);
    }

    @Generated
    public void setEventBatchSize(int v) {
        this.setInt(eventBatchSize, v, null);
    }

    @Generated
    public BRelTime getSendFailWarnInterval() {
        return (BRelTime)this.get(sendFailWarnInterval);
    }

    @Generated
    public void setSendFailWarnInterval(BRelTime v) {
        this.set(sendFailWarnInterval, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    @Generated
    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    @Generated
    public void sendBatchEvents() {
        this.invoke(sendBatchEvents, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.resolveChannel();
        if (this.connectionService == null || this.connectionService.isFatalFault()) {
            log.severe("The Cloud Connection Service is missing or is in fatal fault. Check the host license.");
        }
        if (this.getLastSentToCloud() == BAbsTime.NULL) {
            this.setLastSentToCloud(BAbsTime.now());
        }
        if (this.getEnableBatchEvents()) {
            this.pendingEvents = new BEvent[this.getEventBatchSize()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(cloudConnectionService)) {
            this.resolveChannel();
        }
        if (enableBatchEvents.equals(prop)) {
            if (this.getEnableBatchEvents()) {
                this.pendingEvents = new BEvent[this.getEventBatchSize()];
                this.pendingEventCount = 0;
            } else if (this.pendingEventCount > 0) {
                this.doSendBatchEvents();
                this.pendingEvents = null;
            }
        } else if (eventBatchSize.equals(prop)) {
            if (this.pendingEventCount > this.getEventBatchSize()) {
                this.doSendBatchEvents();
            }
            BEvent[] tmpEvents = new BEvent[this.getEventBatchSize()];
            eventBatchLock.lock();
            try {
                System.arraycopy(this.pendingEvents, 0, tmpEvents, 0, this.pendingEventCount);
                this.pendingEvents = tmpEvents;
            }
            finally {
                eventBatchLock.unlock();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void eventReceived(BEvent event) {
        if (this.eventsChannel == null) {
            this.resolveChannel();
        }
        if (this.eventsChannel == null) {
            log.warning(String.format("CloudLink Event Recipient %s has no Events Channel configured", this.getDisplayName(null)));
            this.clearPendingEvents();
            this.eventSendFailLogFlag = true;
            return;
        }
        if (this.connectionService.isFatalFault()) return;
        if (!this.eventsChannel.canSend()) {
            if (!this.eventSendFailLogFlag) {
                log.warning("Cannot send events while the channel transport is disconnected.");
            }
            this.clearPendingEvents();
            this.eventSendFailLogFlag = true;
            return;
        }
        if (this.getEnableBatchEvents()) {
            eventBatchLock.lock();
            try {
                if (this.eventSendTicket == null) {
                    this.eventSendTicket = Clock.schedule((BComponent)this, (BRelTime)this.getEventBatchDelay(), (Action)sendBatchEvents, null);
                }
                this.pendingEvents[this.pendingEventCount++] = event;
                if (this.pendingEventCount < this.getEventBatchSize()) return;
                log.fine("Queue is full.  Sending messages in batch.");
                this.doSendBatchEvents();
                return;
            }
            finally {
                if (eventBatchLock.isHeldByCurrentThread()) {
                    eventBatchLock.unlock();
                }
            }
        } else {
            this.eventsChannel.sendEvent(event);
        }
    }

    private void resolveChannel() {
        try {
            BOrd serviceOrd = this.getCloudConnectionService();
            if (serviceOrd == BOrd.NULL) {
                BComponent[] services = Sys.getServices((Type)BCloudConnectionService.TYPE);
                if (services != null && services.length == 1) {
                    serviceOrd = services[0].getNavOrd();
                    this.setCloudConnectionService(serviceOrd);
                } else {
                    log.info(() -> String.format("No Cloud Connection Service found to which Cloud Link Event Recipient %s can be connected", this.getName()));
                    return;
                }
            }
            this.connectionService = (BCloudConnectionService)serviceOrd.resolve((BObject)this).get();
            this.eventsChannel = (BEventsChannel)this.connectionService.getChannel("Event");
        }
        catch (Exception e) {
            log.warning(() -> String.format("Cannot resolve events channel for Cloud Link Event Recipient %s: check Cloud Connection Service configuration", this.getName()));
        }
    }

    private void clearPendingEvents() {
        if (this.eventSendTicket != null) {
            this.eventSendTicket.cancel();
            this.eventSendTicket = null;
        }
        for (int lcv = 0; lcv < this.pendingEventCount; ++lcv) {
            this.pendingEvents[lcv] = null;
        }
        this.pendingEventCount = 0;
    }

    public void doSendBatchEvents() {
        BEvent[] events;
        if (this.eventsChannel == null || this.connectionService == null) {
            this.resolveChannel();
        }
        if (this.eventsChannel == null || !this.eventsChannel.canSend()) {
            log.warning(() -> String.format("No events channel configured for Cloud Link Event Recipient %s.", this.getDisplayName(null)));
            this.clearPendingEvents();
            return;
        }
        if (!eventBatchLock.isHeldByCurrentThread()) {
            eventBatchLock.lock();
        }
        try {
            events = new BEvent[this.pendingEventCount];
            System.arraycopy(this.pendingEvents, 0, events, 0, this.pendingEventCount);
            this.clearPendingEvents();
        }
        finally {
            eventBatchLock.unlock();
        }
        this.eventsChannel.sendBatchEvents(events);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("BCloudLinkEventRecipient");
        out.prop((Object)"connectionService", (Object)this.connectionService);
        out.prop((Object)"eventsChannel", (Object)this.eventsChannel);
        out.prop((Object)"pendingEventCount", this.pendingEventCount);
        out.prop((Object)"eventSendTicket", (Object)this.eventSendTicket);
        out.prop((Object)"eventSendFailLogFlag", this.eventSendFailLogFlag);
        out.endProps();
    }
}

