/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BBaseTagCommand;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;

@NiagaraType
public abstract class BWriteTagCommand
extends BBaseTagCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BWriteTagCommand.class);
    public static final String MSG_TEMPLATE = "WriteTagCommand: %s [cloud id %s], %s command [msg id %s]";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected boolean writeTag(String messageId, String cloudId, String namespace, String tag, BIDataValue value, Context cx) {
        Tags tags;
        Optional optTagValue;
        BIObject entity = CloudLinkUtils.findEntity(messageId, cloudId);
        if (!(entity instanceof Entity) || !BWriteTagCommand.isWriteAllowed(entity, cx)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for entity", cloudId, "aborting", messageId));
            return false;
        }
        if (this.excludedNamespaceSet.contains(namespace)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Writes of tags contained in " + namespace + " are not allowed.", cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionaryService dictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        Optional optDictionary = dictionaryService.getTagDictionary(namespace);
        if (!optDictionary.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag dictionary with namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionary dictionary = (BTagDictionary)optDictionary.get();
        Id tagName = Id.newId((String)namespace, (String)tag);
        Optional optTagInfo = dictionary.getTagDefinitions().getTag(tagName);
        if (!optTagInfo.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag with name " + tag + " in namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        TagInfo info = (TagInfo)optTagInfo.get();
        TypeInfo typeInfo = info.getTagType();
        if (!value.getType().getTypeInfo().is(typeInfo)) {
            try {
                value = (BIDataValue)((BIDataValue)typeInfo.getInstance()).decodeFromString(value.toString());
            }
            catch (IOException ex) {
                log.log(Level.INFO, log.isLoggable(Level.FINE) ? ex : null, () -> String.format(MSG_TEMPLATE, "Unable to convert tag value to expected type for " + tag + " in namespace " + namespace, cloudId, "aborting", messageId));
                return false;
            }
        }
        if ((optTagValue = (tags = ((Entity)entity).tags()).get(tagName)).isPresent() && ((BIDataValue)optTagValue.get()).equals(value)) {
            return true;
        }
        try {
            return ((Entity)entity).tags().set(new Tag(tagName, value));
        }
        catch (IllegalArgumentException | UnsupportedOperationException ex) {
            log.log(Level.INFO, log.isLoggable(Level.FINE) ? ex : null, () -> String.format(MSG_TEMPLATE, "Unable to set value for " + tag + " in namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
    }
}

