/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCommand;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BSubscribePointCommand
extends BCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BSubscribePointCommand.class);
    private static final CloudPointSubscriber cloudPointSubscriber = new CloudPointSubscriber();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected Boolean subscribePoint(String messageId, String pointId, Context cx) {
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null) {
            return false;
        }
        if (!this.isLicensed(point)) {
            liclog.warning(() -> String.format("SubscribePointCommand: point %s not licensed", pointId));
            return false;
        }
        if (CloudLinkUtils.isPointReadAllowed(point, cx)) {
            cloudPointSubscriber.subscribe((BComponent)point);
            return true;
        }
        return false;
    }

    protected Boolean unsubscribePoint(String messageId, String pointId, Context cx) {
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null) {
            return false;
        }
        if (!this.isLicensed(point)) {
            liclog.warning(() -> String.format("UnsubscribePointCommand: point %s not licensed", pointId));
            return false;
        }
        if (CloudLinkUtils.isPointReadAllowed(point, cx)) {
            cloudPointSubscriber.unsubscribe((BComponent)point);
            return true;
        }
        return false;
    }

    private static void unsubscribeAll() {
        cloudPointSubscriber.unsubscribeAll();
    }

    static class CloudPointSubscriber
    extends Subscriber {
        CloudPointSubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
        }
    }
}

