/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="source", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="expiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="value", type="BValue", defaultValue="BString.DEFAULT", flags=1)})
@NiagaraAction(name="clearCloudWrite", flags=4)
public class BCloudWriteInfo
extends BComponent {
    @Generated
    public static final Property source = BCloudWriteInfo.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property expiration = BCloudWriteInfo.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property value = BCloudWriteInfo.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action clearCloudWrite = BCloudWriteInfo.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudWriteInfo.class);
    private Clock.Ticket resetTicket;
    private static final Pattern CLOUD_WRITE = Pattern.compile("cloudWrite", 16);

    @Generated
    public String getSource() {
        return this.getString(source);
    }

    @Generated
    public void setSource(String v) {
        this.setString(source, v, null);
    }

    @Generated
    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    @Generated
    public void setExpiration(BAbsTime v) {
        this.set(expiration, (BValue)v, null);
    }

    @Generated
    public BValue getValue() {
        return this.get(value);
    }

    @Generated
    public void setValue(BValue v) {
        this.set(value, v, null);
    }

    @Generated
    public void clearCloudWrite() {
        this.invoke(clearCloudWrite, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
        }
    }

    public void makeTicket() {
        BRelTime resetTime = BAbsTime.now().delta(this.getExpiration());
        this.resetTicket = Clock.schedule((BComponent)this, (BRelTime)resetTime, (Action)clearCloudWrite, null);
    }

    public void doClearCloudWrite() {
        BComponent parent = this.getParent().asComponent();
        Property property = this.getPropertyInParent();
        String linkName = CLOUD_WRITE.matcher(property.getName()).replaceAll(Matcher.quoteReplacement("writeLink"));
        parent.remove(linkName);
        parent.remove(property);
        this.resetTicket = null;
    }

    public BPriorityLevel getPriority() {
        for (Knob knob : this.getKnobs()) {
            if (knob.getTargetComponent() != this.getParent()) continue;
            String slotName = knob.getTargetSlotName();
            if (slotName.length() <= 4) {
                return BPriorityLevel.make((String)("level_" + slotName.substring(2)));
            }
            return BPriorityLevel.fallback;
        }
        return BPriorityLevel.none;
    }
}

