/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BNullClientAuthenticator;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.queue.BAbstractMessageQueue;
import com.tridium.cloudLink.queue.BInMemoryMessageQueue;
import com.tridium.cloudLink.transport.BAbstractConnectionlessTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.BNullTransport;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transportType", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="channelQueue", type="BAbstractMessageQueue", defaultValue="new BInMemoryMessageQueue(5000000)"), @NiagaraProperty(name="maxMessageSize", type="int", defaultValue="1000000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"byte\")")})})
public class BTransportConfig
extends BComponent {
    @Generated
    public static final Property transportType = BTransportConfig.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property authenticatorId = BTransportConfig.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property channelQueue = BTransportConfig.newProperty((int)0, (BValue)new BInMemoryMessageQueue(5000000), null);
    @Generated
    public static final Property maxMessageSize = BTransportConfig.newProperty((int)0, (int)1000000, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"byte")));
    @Generated
    public static final Type TYPE = Sys.loadType(BTransportConfig.class);
    protected BAbstractClientAuthenticator authenticator;
    protected BAbstractTransport transport;
    private static final Logger log = Logger.getLogger("cloudLink.channel");
    private static final String NO_AUTHENTICATOR = "No authenticator";
    private static final String NO_TRANSPORT = "No transport";

    @Generated
    public String getTransportType() {
        return this.getString(transportType);
    }

    @Generated
    public void setTransportType(String v) {
        this.setString(transportType, v, null);
    }

    @Generated
    public String getAuthenticatorId() {
        return this.getString(authenticatorId);
    }

    @Generated
    public void setAuthenticatorId(String v) {
        this.setString(authenticatorId, v, null);
    }

    @Generated
    public BAbstractMessageQueue getChannelQueue() {
        return (BAbstractMessageQueue)this.get(channelQueue);
    }

    @Generated
    public void setChannelQueue(BAbstractMessageQueue v) {
        this.set(channelQueue, (BValue)v, null);
    }

    @Generated
    public int getMaxMessageSize() {
        return this.getInt(maxMessageSize);
    }

    @Generated
    public void setMaxMessageSize(int v) {
        this.setInt(maxMessageSize, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTransportConfig() {
    }

    public BTransportConfig(String transportType, String authenticatorId) {
        this.setTransportType(transportType);
        this.setAuthenticatorId(authenticatorId);
    }

    public BTransportConfig(String transportType, String authenticatorId, int maxMessageSize) {
        this(transportType, authenticatorId);
        this.setMaxMessageSize(maxMessageSize);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected void fwStarted() {
        this.initializeAuthenticator();
        this.initializeTransport();
        this.setFacets((Slot)maxMessageSize, BFacets.make((String)"min", (BIDataValue)BInteger.make((int)10000), (String)"max", (BIDataValue)BInteger.make((int)10000000)));
    }

    protected void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(authenticatorId)) {
            this.initializeAuthenticator();
        } else if (prop.equals(transportType)) {
            this.unregisterTransport();
            this.initializeTransport();
        }
    }

    protected void fwStopped() {
        this.unregisterTransport();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BChannelConfig;
    }

    public void validateConfiguration(String prefix, StringBuilder err) {
        if (this.transport == null) {
            this.initializeTransport();
        }
        if (this.transport == null) {
            log.info(() -> String.format("%s: %s", prefix, NO_TRANSPORT));
            err.append(NO_TRANSPORT).append(';');
        }
        if (this.authenticator == null && (this.transport == null || this.transport instanceof BAbstractConnectionlessTransport)) {
            this.initializeAuthenticator();
        }
        if (this.authenticator == null && (this.transport == null || this.transport instanceof BAbstractConnectionlessTransport)) {
            log.info(() -> String.format("%s: %s with id %s", prefix, NO_AUTHENTICATOR, this.getAuthenticatorId()));
            err.append(NO_AUTHENTICATOR).append(';');
        }
    }

    public void initializeAuthenticator() {
        ((BAbstractClientChannel)this.getParent().getParent()).getConnectionService().ifPresent(srv -> {
            this.authenticator = srv.getAuthenticator(this.getAuthenticatorId());
        });
    }

    protected void initializeTransport() {
        BChannelConfig config = (BChannelConfig)this.getParent();
        ((BAbstractClientChannel)config.getParent()).getConnectionService().ifPresent(srv -> {
            this.transport = srv.getTransport(this.getTransportType());
            this.registerTransport();
        });
    }

    protected void registerTransport() {
        if (this.transport != null) {
            this.transport.registerQueue(this.getChannelQueue());
        }
    }

    protected void unregisterTransport() {
        if (this.transport != null) {
            this.transport.deregisterQueue(this.getChannelQueue());
        }
    }

    BAbstractTransport getTransport() {
        return this.transport != null ? this.transport : new BNullTransport();
    }

    BAbstractClientAuthenticator getAuthenticator() {
        return this.authenticator != null ? this.authenticator : new BNullClientAuthenticator();
    }
}

