/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CloudLinkConstants.CLOUD_LINK_CHANNEL_MESSAGING)", flags=1, override=true)
public class BMessagingChannel
extends BAbstractClientChannel {
    @Generated
    public static final Property channelType = BMessagingChannel.newProperty((int)1, (BValue)BString.make((String)"Messaging"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMessagingChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.messaging");
    private static final String SEND_MESSAGE_ERROR = "Could not send message";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public IMessageResponse send(String transportType, IMessage message) {
        try {
            BAbstractTransport transport = this.getChannelConfig().getTransport(transportType);
            return this.sendAsync(transportType, message).get(transport.getDefaultMessageTimeout().getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "error sending message:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
    }

    public CompletableFuture<IMessageResponse> sendAsync(String transportType, IMessage message) {
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            throw new IllegalStateException(errMsg.get());
        }
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        BAbstractTransport transport = this.getChannelConfig().getTransport(transportType);
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, future, transport.getMessageRetries());
        this.getChannelConfig().enqueueMessage(transportType, wrapper);
        transport.notifyPending();
        return future;
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("MessagingChannel.icon"));
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(SEND_MESSAGE_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }
}

