/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicy;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicyContainer;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_HEARTBEAT)", flags=1, override=true), @NiagaraProperty(name="frequency", type="BRelTime", defaultValue="BRelTime.make(300000L)", flags=7, facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeMinutes(1), BFacets.MAX, BRelTime.makeMinutes(1440))")}), @NiagaraProperty(name="timeoutThreshold", type="int", defaultValue="3", flags=7, facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="policies", type="BHeartbeatPolicyContainer", defaultValue="new BHeartbeatPolicyContainer()")})
public class BHeartbeatChannel
extends BAbstractClientChannel {
    @Generated
    public static final Property channelType = BHeartbeatChannel.newProperty((int)1, (BValue)BString.make((String)"Heartbeat"), null);
    @Generated
    public static final Property frequency = BHeartbeatChannel.newProperty((int)7, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)1440)));
    @Generated
    public static final Property timeoutThreshold = BHeartbeatChannel.newProperty((int)7, (int)3, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property policies = BHeartbeatChannel.newProperty((int)0, (BValue)new BHeartbeatPolicyContainer(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHeartbeatChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat");
    private static final String HEARTBEAT_ERROR = "Could not send heartbeat";
    private static final SendHeartbeatResult FAILED_HEARTBEAT = new SendHeartbeatResult(){

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public Object getResult() {
            return null;
        }
    };

    @Generated
    public BRelTime getFrequency() {
        return (BRelTime)this.get(frequency);
    }

    @Generated
    public void setFrequency(BRelTime v) {
        this.set(frequency, (BValue)v, null);
    }

    @Generated
    public int getTimeoutThreshold() {
        return this.getInt(timeoutThreshold);
    }

    @Generated
    public void setTimeoutThreshold(int v) {
        this.setInt(timeoutThreshold, v, null);
    }

    @Generated
    public BHeartbeatPolicyContainer getPolicies() {
        return (BHeartbeatPolicyContainer)this.get(policies);
    }

    @Generated
    public void setPolicies(BHeartbeatPolicyContainer v) {
        this.set(policies, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public CompletableFuture<SendHeartbeatResult> heartbeat(BHeartbeatPolicy policy) {
        String operationId = policy.getOperationId();
        boolean registered = this.getChannelConfig().getAuthenticator(operationId).isRegistered();
        if (!registered) {
            return CompletableFuture.completedFuture(FAILED_HEARTBEAT);
        }
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            CompletableFuture<SendHeartbeatResult> rv = new CompletableFuture<SendHeartbeatResult>();
            rv.completeExceptionally(new IllegalStateException(errMsg.get()));
            return rv;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(operationId);
        if (!transport.canSend()) {
            CompletableFuture<SendHeartbeatResult> rv = new CompletableFuture<SendHeartbeatResult>();
            rv.complete(FAILED_HEARTBEAT);
            log.warning("Heartbeat message not sent because transport cannot send messages");
            return rv;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        BChannelConfig config = this.getChannelConfig();
        ISendHeartbeatHandler heartbeatHandler = msgFactory.getMessageHandler(ISendHeartbeatHandler.class, config);
        heartbeatHandler.add(policy.getPayloadProperties());
        CompletableFuture<SendHeartbeatResult> rv = this.sendMessage(heartbeatHandler, transport, policy);
        return rv;
    }

    private CompletableFuture<SendHeartbeatResult> sendMessage(ISendHeartbeatHandler messageHandler, BAbstractTransport transport, BHeartbeatPolicy policy) {
        CompletableFuture<SendHeartbeatResult> responseFuture = new CompletableFuture<SendHeartbeatResult>();
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(messageHandler.toMessage(true), messageHandler.getFuture(responseFuture), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(policy.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return responseFuture;
    }

    @Override
    protected void propagateStatus() {
        BHeartbeatPolicyContainer[] containers;
        super.propagateStatus();
        for (BHeartbeatPolicyContainer container : containers = (BHeartbeatPolicyContainer[])this.getChildren(BHeartbeatPolicyContainer.class)) {
            BHeartbeatPolicy[] heartbeatPolicies;
            for (BHeartbeatPolicy heartbeatPolicy : heartbeatPolicies = (BHeartbeatPolicy[])container.getChildren(BHeartbeatPolicy.class)) {
                heartbeatPolicy.updateStatus();
            }
        }
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(HEARTBEAT_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("HeartbeatChannel.icon"));
    }
}

