/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.backup;

import com.tridium.cloudLink.backup.BCloudBackupPolicy;
import com.tridium.cloudLink.channel.BBackupChannel;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultBackupPolicy", type="BCloudBackupPolicy", defaultValue="new BCloudBackupPolicy()", flags=256), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15)))")})
@NiagaraAction(name="retryFailedBackups")
public class BCloudBackupPolicyContainer
extends BComponent {
    @Generated
    public static final Property defaultBackupPolicy = BCloudBackupPolicyContainer.newProperty((int)256, (BValue)new BCloudBackupPolicy(), null);
    @Generated
    public static final Property retryTrigger = BCloudBackupPolicyContainer.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    @Generated
    public static final Action retryFailedBackups = BCloudBackupPolicyContainer.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudBackupPolicyContainer.class);

    @Generated
    public BCloudBackupPolicy getDefaultBackupPolicy() {
        return (BCloudBackupPolicy)this.get(defaultBackupPolicy);
    }

    @Generated
    public void setDefaultBackupPolicy(BCloudBackupPolicy v) {
        this.set(defaultBackupPolicy, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    @Generated
    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    @Generated
    public void retryFailedBackups() {
        this.invoke(retryFailedBackups, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBackupChannel;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BCloudBackupPolicy;
    }

    public void started() throws Exception {
        super.started();
        BTimeTrigger t = this.getRetryTrigger();
        this.linkTo("retryLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)retryFailedBackups);
    }

    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
    }

    public void doRetryFailedBackups() {
        BCloudBackupPolicy[] configs;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudBackupPolicy config : configs = (BCloudBackupPolicy[])this.getChildren(BCloudBackupPolicy.class)) {
            if (config.isUnoperational() || !config.isFault() || !config.retryReady()) continue;
            config.execute();
        }
    }
}

