/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.backup;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.backup.BCloudBackupEncryptionKeyConfig;
import com.tridium.cloudLink.backup.BCloudBackupPolicyContainer;
import com.tridium.cloudLink.channel.BBackupChannel;
import com.tridium.cloudLink.util.BICachingCertificateConsumer;
import com.tridium.cloudLink.util.BRunnableNamedJob;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.SecretChars;
import com.tridium.util.ThrowableUtil;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.category.BCategoryMask;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="DEFAULT_TIME_TRIGGER", override=true), @NiagaraProperty(name="backupNote", type="String", defaultValue="", facets={@Facet(name="BFacets.MAX", value="NOTE_MAX_CHARS")}), @NiagaraProperty(name="encryptionKey", type="BCloudBackupEncryptionKeyConfig", defaultValue="new BCloudBackupEncryptionKeyConfig()"), @NiagaraProperty(name="excludeFiles", type="BString", defaultValue="*.lock;*backup*;console.*;config.bog.b*;config_backup*;dirty.fl"), @NiagaraProperty(name="excludeFolders", type="BOrdList", defaultValue="BOrdList.make(new BOrd[] { BOrd.make(\"file:^^webFileCache\"), BOrd.make(\"file:^^cloudLinkModel\"), BOrd.make(\"file:^^cloudLinkSchedule\"), BOrd.make(\"file:^^orientSystemDb\") })", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE"), @Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IDirectory\")")}), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="initialRetryInterval", type="int", defaultValue="1", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")}), @NiagaraProperty(name="maxRetryInterval", type="int", defaultValue="96")})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public class BCloudBackupPolicy
extends BAbstractDescriptor
implements BIAlarmSource,
BICachingCertificateConsumer {
    @Generated
    public static final Property executionTime = BCloudBackupPolicy.newProperty((int)0, (BValue)CloudLinkConstants.DEFAULT_TIME_TRIGGER, null);
    @Generated
    public static final Property backupNote = BCloudBackupPolicy.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"max", (int)1024));
    @Generated
    public static final Property encryptionKey = BCloudBackupPolicy.newProperty((int)0, (BValue)new BCloudBackupEncryptionKeyConfig(), null);
    @Generated
    public static final Property excludeFiles = BCloudBackupPolicy.newProperty((int)0, (String)"*.lock;*backup*;console.*;config.bog.b*;config_backup*;dirty.fl", null);
    @Generated
    public static final Property excludeFolders = BCloudBackupPolicy.newProperty((int)0, (BValue)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:^^webFileCache"), BOrd.make((String)"file:^^cloudLinkModel"), BOrd.make((String)"file:^^cloudLinkSchedule"), BOrd.make((String)"file:^^orientSystemDb")}), (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory"))));
    @Generated
    public static final Property alarmOnFailure = BCloudBackupPolicy.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmSourceInfo = BCloudBackupPolicy.newProperty((int)0, (BValue)BCloudBackupPolicy.initAlarmSourceInfo(), null);
    @Generated
    public static final Property initialRetryInterval = BCloudBackupPolicy.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property maxRetryInterval = BCloudBackupPolicy.newProperty((int)0, (int)96, null);
    @Generated
    public static final Action ackAlarm = BCloudBackupPolicy.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudBackupPolicy.class);
    protected BJob job;
    protected Context context;
    private AlarmSupport alarmSupport;
    protected static final AtomicBoolean jobRunning = new AtomicBoolean();
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");
    private int retryFailuresCount;
    private int retryInterval = 1;
    private static final int BACKOFF_FACTOR = 2;
    private static final BDaysOfWeekBits[] DAYS = new BDaysOfWeekBits[]{BDaysOfWeekBits.sunday, BDaysOfWeekBits.monday, BDaysOfWeekBits.tuesday, BDaysOfWeekBits.wednesday, BDaysOfWeekBits.thursday, BDaysOfWeekBits.friday, BDaysOfWeekBits.saturday};

    @Generated
    public String getBackupNote() {
        return this.getString(backupNote);
    }

    @Generated
    public void setBackupNote(String v) {
        this.setString(backupNote, v, null);
    }

    @Generated
    public BCloudBackupEncryptionKeyConfig getEncryptionKey() {
        return (BCloudBackupEncryptionKeyConfig)this.get(encryptionKey);
    }

    @Generated
    public void setEncryptionKey(BCloudBackupEncryptionKeyConfig v) {
        this.set(encryptionKey, (BValue)v, null);
    }

    @Generated
    public String getExcludeFiles() {
        return this.getString(excludeFiles);
    }

    @Generated
    public void setExcludeFiles(String v) {
        this.setString(excludeFiles, v, null);
    }

    @Generated
    public BOrdList getExcludeFolders() {
        return (BOrdList)this.get(excludeFolders);
    }

    @Generated
    public void setExcludeFolders(BOrdList v) {
        this.set(excludeFolders, (BValue)v, null);
    }

    @Generated
    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    @Generated
    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public int getInitialRetryInterval() {
        return this.getInt(initialRetryInterval);
    }

    @Generated
    public void setInitialRetryInterval(int v) {
        this.setInt(initialRetryInterval, v, null);
    }

    @Generated
    public int getMaxRetryInterval() {
        return this.getInt(maxRetryInterval);
    }

    @Generated
    public void setMaxRetryInterval(int v) {
        this.setInt(maxRetryInterval, v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.retryFailuresCount = 0;
        this.retryInterval = 1;
        Sys.findService((Type)BIDataRecoveryService.TYPE).ifPresent(s -> {
            BOrd newExclude = BOrd.make((String)"file:^^dataRecovery");
            boolean addToExclude = true;
            for (BOrd anOrdList : this.getExcludeFolders().toArray()) {
                if (!anOrdList.equals((Object)newExclude)) continue;
                addToExclude = false;
                break;
            }
            if (addToExclude) {
                this.setExcludeFolders(BOrdList.add((BOrdList)this.getExcludeFolders(), (BOrd)newExclude));
            }
        });
        BTimeTrigger currentBackupTime = this.getExecutionTime();
        if (currentBackupTime.getTriggerMode().equals((Object)CloudLinkConstants.DEFAULT_TRIGGER_MODE)) {
            int randomDayIndex = (int)(Math.random() * (double)DAYS.length);
            BDaysOfWeekBits randomDay = DAYS[randomDayIndex];
            this.setExecutionTime(new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)3, (int)0, (int)0), (BDaysOfWeekBits)randomDay, (BRelTime)BRelTime.makeHours((int)4))));
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(p, cx);
        if (p.equals(status) && this.getStatus().isDisabled() && jobRunning.get() && this.job != null && this.job.isAlive()) {
            this.job.log().message("cloudLink", "backup.job.canceledByDisabled");
            this.job.cancel();
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudBackupPolicyContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        try {
            if (!this.isRunning()) {
                return;
            }
            BBackupChannel channel = this.getChannel();
            if (channel == null) {
                log.severe("Cloud Backup Policy execution failed. Backup channel not found.");
                return;
            }
            if (this.job == null) {
                log.severe("Cloud Backup Policy execution failed. There is no job to create the backup.");
                return;
            }
            this.job.log().message("cloudLink", "backup.job.start");
            this.job.setJobState(BJobState.running);
            this.executeInProgress();
            String note = BCloudBackupPolicy.truncateNote(this.job, this.getBackupNote());
            BPassword encryptionKey = this.getSelectedEncryptionKey();
            ((CompletableFuture)channel.backup(this.job, this.getExcludeFiles(), this.getExcludeFolders(), note, encryptionKey, this.context).handle((result, exception) -> {
                if (exception != null) {
                    if (exception instanceof InterruptedException) {
                        this.handleInterruptedException((InterruptedException)exception);
                    } else {
                        this.handleException((Throwable)exception);
                    }
                } else {
                    this.executeOk();
                    this.job.log().message("cloudLink", "backup.job.backupSuccess");
                    this.job.success();
                }
                return null;
            })).join();
        }
        finally {
            jobRunning.set(false);
            this.context = null;
        }
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BBoolean.make((boolean)BCloudBackupPolicy.processAlarmAck(this.alarmSupport, ackRequest));
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    public final BCategoryMask getCategoryMask() {
        return this.getParent() == null ? super.getCategoryMask() : this.getParent().asComponent().getCategoryMask();
    }

    public final BCategoryMask getAppliedCategoryMask() {
        return this.getParent() == null ? super.getAppliedCategoryMask() : this.getParent().asComponent().getAppliedCategoryMask();
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BBackupChannel channel = this.getChannel();
        if (channel == null) {
            this.setFaultCause(lex.get("backup.policy.wrongParent", "not in backup container"));
            newStatus |= 2;
        } else {
            newStatus = channel.getStatus().isDisabled() || !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
            newStatus = channel.getStatus().isFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        }
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public void executeOk() {
        this.retryInterval = this.getInitialRetryInterval();
        this.retryFailuresCount = 0;
        if (this.getStatus().isAlarm()) {
            BCloudBackupPolicy.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        super.executeOk();
    }

    public final void executeFail(String reason) {
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            if (reason == null) {
                reason = "";
            }
            boolean ackRequired = BCloudBackupPolicy.processAlarmOffnormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        super.executeFail(reason);
    }

    boolean retryReady() {
        if (++this.retryFailuresCount % this.retryInterval == 0) {
            this.retryInterval *= 2;
            if (this.retryInterval > this.getMaxRetryInterval()) {
                this.retryInterval = this.getMaxRetryInterval();
            }
            this.retryFailuresCount = 0;
            return true;
        }
        return false;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (jobRunning.getAndSet(true)) {
            String msg = "Unable to start cloud backup. A backup job is already in progress.";
            log.warning(msg);
            this.executeFail(msg);
            return null;
        }
        try {
            this.context = cx;
            this.job = this.makeJob(new Invocation((BComponent)this, action, arg, cx));
            this.job.submit(cx);
            log.fine("Backup job started");
        }
        catch (Exception ex) {
            String msg = "Unable to start cloud backup. An error occurred while submitting the job.";
            log.log(Level.WARNING, msg, log.isLoggable(Level.FINE) ? ex : null);
            jobRunning.getAndSet(false);
            this.job = null;
            this.context = null;
            this.executeFail(msg);
        }
        return null;
    }

    @Override
    public Action getCertificateUpdateAction() {
        return execute;
    }

    protected BJob makeJob(Invocation invocation) {
        BRunnableNamedJob namedJob = new BRunnableNamedJob((Runnable)invocation, 1);
        namedJob.setJobName(lex.get("backup.job.name"));
        return namedJob;
    }

    protected void handleInterruptedException(InterruptedException interExcept) {
        this.executeFail(lex.get("backup.job.canceled"));
        this.job.canceled();
    }

    protected void handleException(Throwable except) {
        log.log(Level.WARNING, "Exception in backup job", log.isLoggable(Level.FINE) ? except : null);
        this.executeFail(ThrowableUtil.dumpToString((Throwable)except, (int)1));
        this.job.failed(except);
    }

    protected BBackupChannel getChannel() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BBackupChannel); parent = parent.getParent()) {
        }
        return (BBackupChannel)parent;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLink:backup.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLink:backup.success)%"));
        return asi;
    }

    protected static void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal(null);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process Normal alarm:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    protected static boolean processAlarmOffnormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process off normal alarm: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
        }
        return ackRequired;
    }

    protected static boolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return support.ackAlarm(ackRequest);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot process alarm ack: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return false;
        }
    }

    protected static String truncateNote(BJob job, String note) {
        if (note.length() > 1024) {
            String truncatedNote = note.substring(0, 1024);
            log.info(String.format("Backup note was truncated to %d characters, the maximum supported.", 1024));
            job.log().message("cloudLink", "backup.job.note.truncated");
            return truncatedNote;
        }
        return note;
    }

    private BPassword getSelectedEncryptionKey() {
        if (this.getEncryptionKey().getEncryptionKeyType().isSystemPassphrase()) {
            try (SecretChars passphrase = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getSystemPassword());){
                BPassword bPassword = BPassword.make((char[])passphrase.get());
                return bPassword;
            }
        }
        return AccessController.doPrivileged(() -> BPassword.make((String)this.getEncryptionKey().getPassword().getValue()));
    }
}

