/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.backup;

import com.tridium.cloudLink.backup.BCloudBackupEncryptionKeyType;
import com.tridium.nre.security.SecretChars;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BPasswordStrength;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="encryptionKeyType", type="BCloudBackupEncryptionKeyType", defaultValue="BCloudBackupEncryptionKeyType.systemPassphrase"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.make(\"\")", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"cloudLink:CloudLinkConfirmPasswordFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:ConfirmPasswordEditor\")"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BCloudBackupEncryptionKeyConfig
extends BStruct
implements IPropertyValidator {
    @Generated
    public static final Property encryptionKeyType = BCloudBackupEncryptionKeyConfig.newProperty((int)0, (BValue)BCloudBackupEncryptionKeyType.systemPassphrase, null);
    @Generated
    public static final Property password = BCloudBackupEncryptionKeyConfig.newProperty((int)0, (BValue)BPassword.make((String)""), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"cloudLink:CloudLinkConfirmPasswordFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:ConfirmPasswordEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudBackupEncryptionKeyConfig.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");

    @Generated
    public BCloudBackupEncryptionKeyType getEncryptionKeyType() {
        return (BCloudBackupEncryptionKeyType)this.get(encryptionKeyType);
    }

    @Generated
    public void setEncryptionKeyType(BCloudBackupEncryptionKeyType v) {
        this.set(encryptionKeyType, (BValue)v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        log.finest(() -> "Validating single property " + property.getDefaultDisplayName(context));
        BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
        if (compSpace == null || !compSpace.isProxyComponentSpace()) {
            return this;
        }
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        log.finest(() -> {
            StringBuilder logMsgBuilder = new StringBuilder();
            logMsgBuilder.append("Validating multiple properties: ");
            for (Property p : properties) {
                logMsgBuilder.append(" property: ");
                logMsgBuilder.append(p.getDefaultDisplayName(context));
            }
            return logMsgBuilder.toString();
        });
        BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
        if (compSpace == null || !compSpace.isProxyComponentSpace()) {
            return this;
        }
        return null;
    }

    public void validateSet(Validatable validatable, Context context) {
        BCloudBackupEncryptionKeyType proposedType = (BCloudBackupEncryptionKeyType)validatable.getProposedValue(encryptionKeyType);
        log.finest(() -> {
            BCloudBackupEncryptionKeyType existingType = (BCloudBackupEncryptionKeyType)validatable.getExistingValue(encryptionKeyType);
            return "Context: " + (context == null ? "null" : context) + " Existing Type: " + existingType.getDisplayTag(context) + " Proposed Type: " + proposedType.getDisplayTag(context);
        });
        if (proposedType.isPassword()) {
            BPassword proposedPassword = (BPassword)validatable.getProposedValue(password);
            try (SecretChars passChars = AccessController.doPrivileged(() -> ((BPassword)proposedPassword).getSecretChars());){
                if (!BPasswordStrength.STRONG.isPasswordValid(passChars.get(), null)) {
                    throw new LocalizableRuntimeException("cloudLink", "backup.password.notStrong", new Object[]{BPasswordStrength.STRONG.getMinimumLength(), BPasswordStrength.STRONG.getMinimumLowerCase(), BPasswordStrength.STRONG.getMinimumUpperCase(), BPasswordStrength.STRONG.getMinimumDigits(), BPasswordStrength.STRONG.getMinimumSpecial()});
                }
            }
        }
    }

    public String toString(Context context) {
        return this.getEncryptionKeyType().toString(context);
    }
}

