/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.auth.AbstractKeyStoreHelper;
import com.tridium.nre.security.SecretChars;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.function.Supplier;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.IKeyStore;

public class SignatureKeyStoreHelper
extends AbstractKeyStoreHelper {
    private final Signature signer;

    public SignatureKeyStoreHelper(IKeyStore keyStore, String alias, BPassword password, String subject, Supplier<KeyPairGenerator> keyPairGenSupplier, Supplier<Signature> signatureSupplier) throws Exception {
        super(keyStore, alias, password, subject, keyPairGenSupplier);
        this.signer = signatureSupplier.get();
        this.initialize();
    }

    @Override
    public synchronized byte[] sign(byte[] content) throws Exception {
        this.initialize();
        log.fine("Signing with the private key");
        this.signer.update(content);
        return this.signer.sign();
    }

    @Override
    protected synchronized void keysChanged() throws Exception {
        try (SecretChars secretChars = this.password.getSecretChars();){
            this.signer.initSign((PrivateKey)this.keyStore.getKey(this.alias, secretChars.get()));
        }
    }
}

