/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.provisioning.CloudLinkConfiguration;
import com.tridium.cloudLink.provisioning.ComponentConfiguration;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class FederatedIdentityDeviceProvisioningInfoResponse {
    private final int statusCode;
    private String eTag = "";
    private CloudLinkConfiguration config;
    private int retry = 900;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String CLOUD_LINK = "cloudLink";
    private static final String AUTHENTICATORS = "authenticators";
    private static final String TRANSPORTS = "transports";
    private static final String CHANNELS = "channels";
    private static final String COMPONENTS = "components";
    private static final String E_TAG = "ETag";
    private static final String NAME = "name";
    private static final String MODULE = "module";
    private static final String TYPE = "type";
    private static final String FACETS = "facets";
    private static final String FLAGS = "flags";
    private static final String VALUE = "value";
    private static final String PROPERTIES = "properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedIdentityDeviceProvisioningInfoResponse(HttpResponseMessage message) {
        try {
            this.statusCode = message.getStatusCode();
            List<String> headers = message.getHeaders().get("retry-after");
            if (headers != null && !headers.isEmpty()) {
                this.retry = Integer.parseInt(headers.get(0));
            }
            if ((headers = message.getHeaders().get("content-type")) == null || !headers.contains("application/json")) {
                log.info("device provisioning response, expected JSON" + (headers == null || headers.isEmpty() ? "" : " but got " + headers.get(0)));
                return;
            }
            headers = message.getHeaders().get(E_TAG);
            if (headers != null && !headers.isEmpty()) {
                this.eTag = headers.get(0);
            }
            JSONObject data = new JSONObject(message.getBodyAsString());
            JSONObject clProvisioningData = data.getJSONObject(CLOUD_LINK);
            this.config = new CloudLinkConfiguration();
            JSONArray authenticators = clProvisioningData.getJSONArray(AUTHENTICATORS);
            for (int lcv = 0; lcv < authenticators.length(); ++lcv) {
                JSONObject authenticator = authenticators.getJSONObject(lcv);
                this.config.addAuthenticator(FederatedIdentityDeviceProvisioningInfoResponse.getComponentConfiguration(authenticator));
            }
            JSONArray transports = clProvisioningData.getJSONArray(TRANSPORTS);
            for (int lcv = 0; lcv < transports.length(); ++lcv) {
                JSONObject transport = transports.getJSONObject(lcv);
                this.config.addTransport(FederatedIdentityDeviceProvisioningInfoResponse.getComponentConfiguration(transport));
            }
            JSONArray channels = clProvisioningData.getJSONArray(CHANNELS);
            for (int lcv = 0; lcv < channels.length(); ++lcv) {
                JSONObject channel = channels.getJSONObject(lcv);
                this.config.addChannel(FederatedIdentityDeviceProvisioningInfoResponse.getComponentConfiguration(channel));
            }
            JSONArray components = clProvisioningData.optJSONArray(COMPONENTS);
            if (components != null) {
                for (int lcv = 0; lcv < components.length(); ++lcv) {
                    JSONObject component = components.getJSONObject(lcv);
                    this.config.addComponent(FederatedIdentityDeviceProvisioningInfoResponse.getComponentConfiguration(component));
                }
            }
        }
        finally {
            if (message != null) {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getETag() {
        return this.eTag;
    }

    public int getRetry() {
        return this.retry;
    }

    public CloudLinkConfiguration getConfig() {
        return this.config;
    }

    private static ComponentConfiguration getComponentConfiguration(JSONObject componentData) {
        String name = componentData.getString(NAME);
        String module = componentData.getString(MODULE);
        String type = componentData.getString(TYPE);
        String facets = componentData.optString(FACETS, null);
        String flags = componentData.optString(FLAGS, null);
        Object value = componentData.opt(VALUE);
        ComponentConfiguration config = new ComponentConfiguration(name, module, type, facets, flags, value);
        JSONArray children = componentData.optJSONArray(PROPERTIES);
        if (children != null) {
            for (int lcv = 0; lcv < children.length(); ++lcv) {
                config.addProperty(FederatedIdentityDeviceProvisioningInfoResponse.getComponentConfiguration(children.getJSONObject(lcv)));
            }
        }
        return config;
    }
}

