/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.security.cert.X509Certificate;
import java.util.List;

public final class FederatedIdentityCsrResponse {
    private final int statusCode;
    private String resultMessage;
    private X509Certificate[] certificates;
    private static final String MESSAGE = "message";
    private static final String RESPONSE = "response";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedIdentityCsrResponse(HttpResponseMessage message) throws Exception {
        try {
            this.statusCode = message.getStatusCode();
            List<String> headers = message.getHeaders().get("content-type");
            if (headers == null || !headers.contains("application/json")) {
                return;
            }
            JSONObject data = new JSONObject(message.getBodyAsString());
            this.resultMessage = data.getString(MESSAGE);
            JSONArray certs = data.getJSONArray(RESPONSE);
            this.certificates = new X509Certificate[certs.length()];
            for (int lcv = 0; lcv < certs.length(); ++lcv) {
                this.certificates[lcv] = NX509Certificate.make((String)certs.getString(lcv)).getCertificate();
            }
        }
        finally {
            if (message != null) {
                message.close();
            }
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.certificates != null && this.certificates.length > 0;
    }

    public String getMessage() {
        return this.resultMessage;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }
}

