/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class FederatedIdentityBootstrapResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private final int statusCode;
    private String deviceCode;
    private String userCode;
    private String directRegistrationUrl;
    private BAbsTime expiration;
    private static final String DEVICE_CODE = "deviceCode";
    private static final String DIRECT_REGISTRATION_URL = "directRegistrationUrl";
    private static final String EXPIRATION_TIME_IN_SECONDS = "expirationTimeInSeconds";
    private static final String USER_CODE = "userCode";
    public static final String BOOTSTRAP_ERROR_MSG_TEMPLATE = "Federated Identity Bootstrap response body is not in %s format, response body is %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedIdentityBootstrapResponse(HttpResponseMessage message) {
        try {
            this.statusCode = message.getStatusCode();
            List<String> headers = message.getHeaders().get("content-type");
            if (headers == null || !headers.contains("application/json")) {
                log.config(() -> String.format(BOOTSTRAP_ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
                return;
            }
            JSONObject data = new JSONObject(message.getBodyAsString());
            this.deviceCode = data.getString(DEVICE_CODE);
            this.userCode = data.getString(USER_CODE);
            this.directRegistrationUrl = data.getString(DIRECT_REGISTRATION_URL);
            this.expiration = BAbsTime.now().add(BRelTime.makeSeconds((int)data.getInt(EXPIRATION_TIME_IN_SECONDS)));
            log.finest(() -> String.format("Federated Identity Bootstrap response status = %d, Device Code = %s, User Code = %s, Registration URL = %s, Expiration = %s", this.statusCode, this.deviceCode, this.userCode, this.directRegistrationUrl, this.expiration));
        }
        finally {
            if (message != null) {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.deviceCode != null && !this.deviceCode.isEmpty();
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getRegistrationUrl() {
        return this.directRegistrationUrl;
    }

    public BAbsTime getExpirationTime() {
        return this.expiration;
    }
}

