/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BAbstractTokenProvider;
import com.tridium.cloudLink.auth.BNullTokenProvider;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.transport.BAbstractTransport;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_TOKEN)", flags=1, override=true), @NiagaraProperty(name="systemId", type="BString", defaultValue="BString.DEFAULT", flags=261, override=true), @NiagaraProperty(name="tokenProvider", type="BAbstractTokenProvider", defaultValue="new BNullTokenProvider()")})
public class BTokenAuthenticator
extends BAbstractClientAuthenticator {
    @Generated
    public static final Property authenticatorId = BTokenAuthenticator.newProperty((int)1, (BValue)BString.make((String)"Token"), null);
    @Generated
    public static final Property systemId = BTokenAuthenticator.newProperty((int)261, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property tokenProvider = BTokenAuthenticator.newProperty((int)0, (BValue)new BNullTokenProvider(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTokenAuthenticator.class);
    private BMessagingChannel messagingChannel;
    private static final Logger log = Logger.getLogger("cloudLink.auth");

    @Generated
    public BAbstractTokenProvider getTokenProvider() {
        return (BAbstractTokenProvider)this.get(tokenProvider);
    }

    @Generated
    public void setTokenProvider(BAbstractTokenProvider v) {
        this.set(tokenProvider, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        Optional<BCloudConnectionService> optCCS = this.getConnectionService();
        if (!optCCS.isPresent() || optCCS.get().isFatalFault()) {
            log.info("Token authenticator unable to locate cloud connection service.");
            return;
        }
        this.messagingChannel = (BMessagingChannel)optCCS.get().getChannel("Messaging");
    }

    @Override
    public void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        Optional<String> tokenOpt = this.getTokenProvider().getToken(this.messagingChannel);
        if (tokenOpt.isPresent()) {
            encoderProps.put("Authorization", "Bearer " + tokenOpt.get());
        } else {
            log.warning("A bearer token was not available for the message properties.");
        }
    }

    @Override
    public Map<String, Object> getPlatformProperties() {
        return new HashMap<String, Object>();
    }

    @Override
    public boolean canAuthenticate() {
        return this.getTokenProvider().canAuthenticate();
    }

    @Override
    public boolean isRegistered() {
        return this.getTokenProvider().canAuthenticate();
    }
}

