/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.audit;

import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.history.audit.BAbstractAuditRecord;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.ITruncatable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationUserName", type="String", defaultValue=""), @NiagaraProperty(name="cloudIdentity", type="String", defaultValue=""), @NiagaraProperty(name="operationId", type="String", defaultValue=""), @NiagaraProperty(name="operationParameters", type="String", defaultValue="")})
public class BCloudAuditRecord
extends BAbstractAuditRecord
implements ITruncatable {
    @Generated
    public static final Property stationUserName = BCloudAuditRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property cloudIdentity = BCloudAuditRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property operationId = BCloudAuditRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property operationParameters = BCloudAuditRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudAuditRecord.class);
    protected static final Logger log = Logger.getLogger("cloudLink.audit");

    @Generated
    public String getStationUserName() {
        return this.getString(stationUserName);
    }

    @Generated
    public void setStationUserName(String v) {
        this.setString(stationUserName, v, null);
    }

    @Generated
    public String getCloudIdentity() {
        return this.getString(cloudIdentity);
    }

    @Generated
    public void setCloudIdentity(String v) {
        this.setString(cloudIdentity, v, null);
    }

    @Generated
    public String getOperationId() {
        return this.getString(operationId);
    }

    @Generated
    public void setOperationId(String v) {
        this.setString(operationId, v, null);
    }

    @Generated
    public String getOperationParameters() {
        return this.getString(operationParameters);
    }

    @Generated
    public void setOperationParameters(String v) {
        this.setString(operationParameters, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCloudAuditRecord() {
    }

    public BCloudAuditRecord(BAbsTime timestamp, String operation, String stationUserName, String cloudIdentity, String operationId, String operationParameters) {
        super(timestamp);
        this.setOperation(operation);
        this.setStationUserName(stationUserName);
        this.setCloudIdentity(cloudIdentity);
        this.setOperationId(operationId);
        this.setOperationParameters(operationParameters);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput dataInput) throws IOException {
        this.setOperation(dataInput.readUTF());
        this.setStationUserName(dataInput.readUTF());
        this.setCloudIdentity(dataInput.readUTF());
        this.setOperationId(dataInput.readUTF());
        this.setOperationParameters(dataInput.readUTF());
    }

    protected void doWrite(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getOperation());
        dataOutput.writeUTF(this.getStationUserName());
        dataOutput.writeUTF(this.getCloudIdentity());
        dataOutput.writeUTF(this.getOperationId());
        dataOutput.writeUTF(this.getOperationParameters());
    }

    public boolean truncate(int maxBytes) {
        ByteBuffer timestampBytes = new ByteBuffer(16);
        try {
            if (this.version == 1) {
                this.getTimestamp().encode((DataOutput)timestampBytes);
            } else {
                this.getTimestamp().encode48((DataOutput)timestampBytes);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        int fixedBytes = timestampBytes.getLength() + ByteBuffer.utfEncodedSize((String)this.getOperation()) + ByteBuffer.utfEncodedSize((String)this.getStationUserName()) + ByteBuffer.utfEncodedSize((String)this.getCloudIdentity()) + ByteBuffer.utfEncodedSize((String)this.getOperationId());
        if (fixedBytes > maxBytes - 2) {
            return false;
        }
        String parameterString = this.getOperationParameters();
        int parameterBytes = ByteBuffer.utfEncodedSize((String)parameterString);
        if (fixedBytes + parameterBytes <= maxBytes) {
            return true;
        }
        int messageLen = maxBytes - fixedBytes - 2;
        parameterBytes = ByteBuffer.utfEncodedSize((String)parameterString.substring(0, messageLen));
        while (fixedBytes + parameterBytes > maxBytes) {
            parameterBytes -= ByteBuffer.utfEncodedSize((char)parameterString.charAt(--messageLen));
        }
        this.setOperationParameters(parameterString.substring(0, messageLen));
        return true;
    }

    public static BCloudAuditRecord fromCommandRequest(CommandRequest request) {
        BAbsTime timestamp = BAbsTime.now();
        Object auth = request.getAuth();
        String subject = null;
        if (auth != null) {
            try {
                String[] parts = auth.toString().split("\\.");
                JSONObject claims = new JSONObject(new String(Base64.getDecoder().decode(parts[1]), StandardCharsets.UTF_8));
                subject = claims.optString("sub", null);
            }
            catch (JSONException | IllegalArgumentException ex) {
                log.log(Level.INFO, "error processing jwt", log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        if (subject == null) {
            subject = request.getCaller();
        }
        return new BCloudAuditRecord(timestamp, request.getCommandName(), request.getUser().getUsername(), subject, request.getCommandId(), request.getCommandParams());
    }
}

