/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.audit;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.audit.BCloudAuditRecord;
import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.history.audit.BAbstractAuditHistorySource;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.util.HistoryCategoryUtil;
import java.util.Optional;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.make(\"station\", \"Cloud Audit History\"), BTypeSpec.make(\"cloudLink\", \"CloudAuditRecord\"))", override=true)
public class BCloudAuditHistorySource
extends BAbstractAuditHistorySource
implements BIRestrictedComponent {
    @Generated
    public static final Property historyConfig = BCloudAuditHistorySource.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make((String)"station", (String)"Cloud Audit History"), BTypeSpec.make((String)"cloudLink", (String)"CloudAuditRecord")), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudAuditHistorySource.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BTypeSpec getRecordType() {
        return BTypeSpec.make((String)"cloudLink", (String)"CloudAuditRecord");
    }

    protected BHistoryId getHistoryId() {
        return BHistoryId.make((String)Sys.getStation().getStationName(), (String)"CloudAuditHistory");
    }

    protected void auditStarted() {
    }

    protected void auditStopped() {
    }

    public void audit(CommandRequest request) {
        BCloudAuditRecord rec = BCloudAuditRecord.fromCommandRequest(request);
        this.audit(rec);
    }

    public void stopped() {
        this.stopAudit();
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        CloudLinkUtils.checkParentForDuplicates(parent, (BComponent)this, BCloudConnectionService.TYPE, false, cx);
    }

    protected Optional<BCategoryMask> getHistoryCategoryMask(HistoryDatabaseConnection conn, BIHistory history) {
        BComplex parent = this.getParent();
        Property propertyInParent = this.getPropertyInParent();
        int flags = this.getParent().getFlags((Slot)propertyInParent);
        if ((flags & 0x10000000) != 0) {
            return Optional.empty();
        }
        Optional<BCategoryMask> result = Optional.empty();
        BAuditHistoryService auditHistoryService = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
        BHistoryId auditHistoryId = auditHistoryService.getHistoryConfig().getId();
        BIHistory auditHistory = conn.getHistory(auditHistoryId);
        if (auditHistory != null) {
            BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            BOrd historyOrd = HistoryCategoryUtil.convertToShorthand((BOrd)auditHistory.getOrdInSession(), (String)Sys.getStation().getStationName());
            BCategoryMask mask = categoryService.getOrdMap().getCategoryMask(historyOrd);
            result = Optional.ofNullable(mask);
        }
        parent.setFlags((Slot)propertyInParent, flags | 0x10000000);
        return result;
    }
}

